
package Apache::MP3::L10N::cs;  # Czech
use strict;
use Apache::MP3::L10N;
use vars qw($VERSION @ISA %Lexicon);
@ISA = qw(Apache::MP3::L10N);
sub language_tag {__PACKAGE__->SUPER::language_tag}

# Translators for this module, in no particular order:
#  Rado Hrabcak duffy@duffy.sk

sub encoding { "iso-8859-2" }   # Latin-2
  # Change as necessary if you use a different encoding

%Lexicon = (
 '_VERSION' => __PACKAGE__ . ' v' . ($VERSION =
   '20020612'), # Last modified


 # These are links as well as button text:
 'Play All' => "Prohrt vechno",
 'Shuffle All' => 'Prohrt v nhodnm poad',  # Stream all in random order
 'Stream All' => 'Prohrt vechno',

 # This one in just button text
 'Play Selected' => 'Prohrt vybran',

 "In this demo, streaming is limited to approximately [quant,_1,second,seconds]."
  => "V tomto demu je prohrvan omezeno na [quant,_1,sekundu,sekund].",
  # In [quant,_1,seconde,secondes], the seconde is the singular form, and the secondes is the plural.

 # Headings:
 'CD Directories ([_1])' => 'CD adrese ([_1])',
 'Playlists ([_1])' => 'Playlisty ([_1])',        # .m3u files
 'Song List ([_1])' => 'Seznam skladeb ([_1])', # i.e., file list


 'Playlist' => 'Playlist',
 'Select' => 'Vybrat',

 'fetch'  => 'uloit', # Send/download/save this file
 'stream' => 'prohrt',    # this file

 'Shuffle'  => 'Nhodn poad',  # a subdirectory, recursively
 'Stream'   => 'Prohrt',            # a subdirectory, recursively

 # Label for a link to "http://[servername]/"
 'Home' => 'Na zatek',

 # Credits
 "_CREDITS_before_author" => "Apache::MP3 byl napsan ",
 "_CREDITS_author"        => "Lincolnem D. Steinem", 
 "_CREDITS_after_author"  => ".",

 # Let me know if this word order isn't good for your language.


 'unknown' => '?',
   # Used when a file doesn't specify its album name, artist name,
   # year of release, etc.


 # Metadata fields:
 'Artist' => "Interpret",
 'Comment' => "Poznmky",
 'Duration' => "Dlka",
 'Filename' => "Nzev",
 'Genre' => "ner",  # i.e., what kind of music
 'Album' => "Album",
 'Min' => "min.",  # abbreviation for "minutes"
 'Track' => "Skladba",  # just the track number (not the track name)
 'Sec' => "sek.",  # abbreviation for "seconds"
 'Seconds' => "Sekund",
 'Title' => "Nzev",
 'Year' => "Rok",

 'Samplerate' => "Kvalita pvodnho zvuku",
 'Bitrate' => "Kvalita zvuku (bitrate)",
   # The sample rate is basically a number reflecting the audio quality
   # of the audio file before compression.  The bitrate is basically
   # a number reflecting the audio quality of the file after compression.
   # I think you can feel free to translate these as "Original sound quality"
   # and "Sound quality", or "Source fidelity" and "Fidelity", etc.


 # Now the stuff for the help page:

 'Quick Help Summary' => "Pehled npovdy",
  # page title as well as the text we use for linking to that page

 "= Stream all songs" => "= Prohrt vechny skladby",
 "= Shuffle-play all Songs" => "= Prohrt vechny skladby v nhodnm poad",
 "= Go to earlier directory" => "= O rove v",
       # i.e., just a link to ../ or higher
 "= Stream contents" => "= Prohrt obsah",
 "= Enter directory" => "= Do adrese",
 "= Stream this song" => "= Prohrt tuto skladbu",
 "= Select for streaming" => "= Vybrt pro prohrti",
 "= Download this song" => "= Uloit tuto skladbu",
 "= Stream this song" => "= Prohrt tuto skladbu",
 "= Sort by field" => "= Seadit dle",
    # "sort" in the sense of ordering, not separating out.
);

1;

