# Generated by default/object.tt
package Paws::SageMaker::EdgeModel;
  use Moose;
  has LatestInference => (is => 'ro', isa => 'Str');
  has LatestSampleTime => (is => 'ro', isa => 'Str');
  has ModelName => (is => 'ro', isa => 'Str', required => 1);
  has ModelVersion => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::EdgeModel

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::EdgeModel object:

  $service_obj->Method(Att1 => { LatestInference => $value, ..., ModelVersion => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::EdgeModel object:

  $result = $service_obj->Method(...);
  $result->Att1->LatestInference

=head1 DESCRIPTION

The model on the edge device.

=head1 ATTRIBUTES


=head2 LatestInference => Str

The timestamp of the last inference that was made.


=head2 LatestSampleTime => Str

The timestamp of the last data sample taken.


=head2 B<REQUIRED> ModelName => Str

The name of the model.


=head2 B<REQUIRED> ModelVersion => Str

The model version.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

