
package Shipment::UPS::WSDL::XAVElements::XAVRequest;
$Shipment::UPS::WSDL::XAVElements::XAVRequest::VERSION = '3.02';
use strict;
use warnings;

{    # BLOCK to scope variables

    sub get_xmlns {'http://www.ups.com/XMLSchema/XOLTWS/xav/v1.0'}

    __PACKAGE__->__set_name('XAVRequest');
    __PACKAGE__->__set_nillable();
    __PACKAGE__->__set_minOccurs();
    __PACKAGE__->__set_maxOccurs();
    __PACKAGE__->__set_ref();

    use base qw(
      SOAP::WSDL::XSD::Typelib::Element
      SOAP::WSDL::XSD::Typelib::ComplexType
    );

    our $XML_ATTRIBUTE_CLASS;
    undef $XML_ATTRIBUTE_CLASS;

    sub __get_attr_class {
        return $XML_ATTRIBUTE_CLASS;
    }

    use Class::Std::Fast::Storable constructor => 'none';
    use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

    Class::Std::initialize();

    {    # BLOCK to scope variables

        my %Request_of : ATTR(:get<Request>);
        my %RegionalRequestIndicator_of : ATTR(:get<RegionalRequestIndicator>);
        my %MaximumCandidateListSize_of : ATTR(:get<MaximumCandidateListSize>);
        my %AddressKeyFormat_of : ATTR(:get<AddressKeyFormat>);

        __PACKAGE__->_factory(
            [   qw(        Request
                  RegionalRequestIndicator
                  MaximumCandidateListSize
                  AddressKeyFormat

                  )
            ],
            {   'Request'                  => \%Request_of,
                'RegionalRequestIndicator' => \%RegionalRequestIndicator_of,
                'MaximumCandidateListSize' => \%MaximumCandidateListSize_of,
                'AddressKeyFormat'         => \%AddressKeyFormat_of,
            },
            {   'Request' => 'Shipment::UPS::WSDL::XAVElements::Request',

                'RegionalRequestIndicator' =>
                  'SOAP::WSDL::XSD::Typelib::Builtin::string',
                'MaximumCandidateListSize' =>
                  'SOAP::WSDL::XSD::Typelib::Builtin::string',
                'AddressKeyFormat' =>
                  'Shipment::UPS::WSDL::XAVTypes::AddressKeyFormatType',
            },
            {

                'Request'                  => '',
                'RegionalRequestIndicator' => 'RegionalRequestIndicator',
                'MaximumCandidateListSize' => 'MaximumCandidateListSize',
                'AddressKeyFormat'         => 'AddressKeyFormat',
            }
        );

    }    # end BLOCK


}    # end of BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::UPS::WSDL::XAVElements::XAVRequest

=head1 VERSION

version 3.02

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
XAVRequest from the namespace http://www.ups.com/XMLSchema/XOLTWS/xav/v1.0.

=head1 NAME

Shipment::UPS::WSDL::XAVElements::XAVRequest

=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Request

 $element->set_Request($data);
 $element->get_Request();

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

=item * RegionalRequestIndicator

 $element->set_RegionalRequestIndicator($data);
 $element->get_RegionalRequestIndicator();

=item * MaximumCandidateListSize

 $element->set_MaximumCandidateListSize($data);
 $element->get_MaximumCandidateListSize();

=item * AddressKeyFormat

 $element->set_AddressKeyFormat($data);
 $element->get_AddressKeyFormat();

=back

=head1 METHODS

=head2 new

 my $element = Shipment::UPS::WSDL::XAVElements::XAVRequest->new($data);

Constructor. The following data structure may be passed to new():

 {
   Request =>  { # Shipment::UPS::WSDL::XAVTypes::RequestType
     RequestOption =>  $some_value, # string
     TransactionReference =>  { # Shipment::UPS::WSDL::XAVTypes::TransactionReferenceType
       CustomerContext =>  $some_value, # string
       TransactionIdentifier =>  $some_value, # string
     },
   },
   RegionalRequestIndicator =>  $some_value, # string
   MaximumCandidateListSize =>  $some_value, # string
   AddressKeyFormat =>  { # Shipment::UPS::WSDL::XAVTypes::AddressKeyFormatType
     ConsigneeName =>  $some_value, # string
     AttentionName =>  $some_value, # string
     AddressLine =>  $some_value, # string
     PoliticalDivision2 =>  $some_value, # string
     PoliticalDivision1 =>  $some_value, # string
     PostcodePrimaryLow =>  $some_value, # string
     PostcodeExtendedLow =>  $some_value, # string
     Region =>  $some_value, # string
     Urbanization =>  $some_value, # string
     CountryCode =>  $some_value, # string
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
