# Generated by default/object.tt
package Paws::SageMaker::MonitoringScheduleSummary;
  use Moose;
  has CreationTime => (is => 'ro', isa => 'Str', required => 1);
  has EndpointName => (is => 'ro', isa => 'Str');
  has LastModifiedTime => (is => 'ro', isa => 'Str', required => 1);
  has MonitoringJobDefinitionName => (is => 'ro', isa => 'Str');
  has MonitoringScheduleArn => (is => 'ro', isa => 'Str', required => 1);
  has MonitoringScheduleName => (is => 'ro', isa => 'Str', required => 1);
  has MonitoringScheduleStatus => (is => 'ro', isa => 'Str', required => 1);
  has MonitoringType => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::MonitoringScheduleSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::MonitoringScheduleSummary object:

  $service_obj->Method(Att1 => { CreationTime => $value, ..., MonitoringType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::MonitoringScheduleSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationTime

=head1 DESCRIPTION

Summarizes the monitoring schedule.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CreationTime => Str

The creation time of the monitoring schedule.


=head2 EndpointName => Str

The name of the endpoint using the monitoring schedule.


=head2 B<REQUIRED> LastModifiedTime => Str

The last time the monitoring schedule was modified.


=head2 MonitoringJobDefinitionName => Str

The name of the monitoring job definition that the schedule is for.


=head2 B<REQUIRED> MonitoringScheduleArn => Str

The Amazon Resource Name (ARN) of the monitoring schedule.


=head2 B<REQUIRED> MonitoringScheduleName => Str

The name of the monitoring schedule.


=head2 B<REQUIRED> MonitoringScheduleStatus => Str

The status of the monitoring schedule.


=head2 MonitoringType => Str

The type of the monitoring job definition that the schedule is for.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

