# Generated by default/object.tt
package Paws::ACMPCA::KeyUsage;
  use Moose;
  has CRLSign => (is => 'ro', isa => 'Bool');
  has DataEncipherment => (is => 'ro', isa => 'Bool');
  has DecipherOnly => (is => 'ro', isa => 'Bool');
  has DigitalSignature => (is => 'ro', isa => 'Bool');
  has EncipherOnly => (is => 'ro', isa => 'Bool');
  has KeyAgreement => (is => 'ro', isa => 'Bool');
  has KeyCertSign => (is => 'ro', isa => 'Bool');
  has KeyEncipherment => (is => 'ro', isa => 'Bool');
  has NonRepudiation => (is => 'ro', isa => 'Bool');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ACMPCA::KeyUsage

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ACMPCA::KeyUsage object:

  $service_obj->Method(Att1 => { CRLSign => $value, ..., NonRepudiation => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ACMPCA::KeyUsage object:

  $result = $service_obj->Method(...);
  $result->Att1->CRLSign

=head1 DESCRIPTION

Defines one or more purposes for which the key contained in the
certificate can be used. Default value for each option is false.

=head1 ATTRIBUTES


=head2 CRLSign => Bool

Key can be used to sign CRLs.


=head2 DataEncipherment => Bool

Key can be used to decipher data.


=head2 DecipherOnly => Bool

Key can be used only to decipher data.


=head2 DigitalSignature => Bool

Key can be used for digital signing.


=head2 EncipherOnly => Bool

Key can be used only to encipher data.


=head2 KeyAgreement => Bool

Key can be used in a key-agreement protocol.


=head2 KeyCertSign => Bool

Key can be used to sign certificates.


=head2 KeyEncipherment => Bool

Key can be used to encipher data.


=head2 NonRepudiation => Bool

Key can be used for non-repudiation.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ACMPCA>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

