# Generated by default/object.tt
package Paws::AppMesh::TcpRoute;
  use Moose;
  has Action => (is => 'ro', isa => 'Paws::AppMesh::TcpRouteAction', request_name => 'action', traits => ['NameInRequest'], required => 1);
  has Timeout => (is => 'ro', isa => 'Paws::AppMesh::TcpTimeout', request_name => 'timeout', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppMesh::TcpRoute

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppMesh::TcpRoute object:

  $service_obj->Method(Att1 => { Action => $value, ..., Timeout => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppMesh::TcpRoute object:

  $result = $service_obj->Method(...);
  $result->Att1->Action

=head1 DESCRIPTION

An object that represents a TCP route type.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Action => L<Paws::AppMesh::TcpRouteAction>

The action to take if a match is determined.


=head2 Timeout => L<Paws::AppMesh::TcpTimeout>

An object that represents types of timeouts.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppMesh>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

