package Digest::HighwayHash;

use 5.014000;
use strict;
use warnings;
use parent qw/Exporter/;

our @EXPORT_OK = qw/highway_hash64 highway_hash128 highway_hash256/;
our @EXPORT = @EXPORT_OK;

our $VERSION = '0.000_001';

use Math::Int64;

require XSLoader;
XSLoader::load('Digest::HighwayHash', $VERSION);

1;
__END__

=encoding utf-8

=head1 NAME

Digest::HighwayHash - fast strong hash function

=head1 SYNOPSIS

  use Digest::HighwayHash;
  say highway_hash64 [1, 2, 3, 4], 'hello';
  # 11956820856122239241
  say join ' ', @{highway_hash128([1, 2, 3, 4], 'hello')};
  # 3048112761216189476 13900443277579286659
  say join ' ', @{highway_hash256([1, 2, 3, 4], 'hello')};
  # 8099666330974151427 17027479935588128037 4015249936799013189 10027181291351549853

=head1 DESCRIPTION

HighwayHash is a fast and strong hash function, documented at
L<https://github.com/google/highwayhash>.

=head1 SEE ALSO

L<https://github.com/google/highwayhash>

=head1 AUTHOR

Marius Gavrilescu, E<lt>marius@ieval.roE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2018 by Marius Gavrilescu

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.24.1 or,
at your option, any later version of Perl 5 you may have available.


=cut
