/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.AxisIteratorImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;

final class PrecedingEnumeration
extends AxisIteratorImpl {
    private TinyTree tree;
    private TinyNodeImpl startNode;
    private NodeTest test;
    private int nextAncestorDepth;
    private boolean includeAncestors;

    public PrecedingEnumeration(TinyTree doc, TinyNodeImpl node, NodeTest nodeTest, boolean includeAncestors) {
        this.includeAncestors = includeAncestors;
        this.test = nodeTest;
        this.tree = doc;
        this.startNode = node;
        this.current = this.startNode;
        this.nextAncestorDepth = doc.depth[node.nodeNr] - 1;
    }

    public NodeInfo next() {
        if (this.current == null) {
            return null;
        }
        int nextNodeNr = ((TinyNodeImpl)this.current).nodeNr;
        do {
            if (!this.includeAncestors) {
                --nextNodeNr;
                while (this.nextAncestorDepth >= 0 && this.tree.depth[nextNodeNr] == this.nextAncestorDepth) {
                    if (this.nextAncestorDepth-- <= 0) {
                        this.current = null;
                        this.position = -1;
                        return null;
                    }
                    --nextNodeNr;
                }
            } else {
                if (this.tree.depth[nextNodeNr] == 0) {
                    this.current = null;
                    this.position = -1;
                    return null;
                }
                --nextNodeNr;
            }
            if (!this.test.matches(this.tree, nextNodeNr)) continue;
            ++this.position;
            this.current = this.tree.getNode(nextNodeNr);
            return this.current;
        } while (this.tree.depth[nextNodeNr] != 0);
        this.current = null;
        this.position = -1;
        return null;
    }

    public AxisIterator getAnother() {
        return new PrecedingEnumeration(this.tree, this.startNode, this.test, this.includeAncestors);
    }
}

