/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ncx;

import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;

public class NCXHandler
implements XMLHandler {
    XMLParser parser;
    String path;
    XRefChecker xrefChecker;
    String uid;

    NCXHandler(XMLParser parser, String path, XRefChecker xrefChecker) {
        this.parser = parser;
        this.path = path;
        this.xrefChecker = xrefChecker;
    }

    @Override
    public void characters(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void startElement() {
        XMLElement e = this.parser.getCurrentElement();
        String ns = e.getNamespace();
        String name = e.getName();
        if (ns.equals("http://www.daisy.org/z3986/2005/ncx/")) {
            String metaContent;
            String metaName;
            if (name.equals("content")) {
                String href = e.getAttribute("src");
                if (href != null) {
                    if ((href = PathUtil.resolveRelativeReference(this.path, href, null)).startsWith("http")) {
                        this.parser.getReport().info(this.path, FeatureEnum.REFERENCE, href);
                    }
                    this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, 1);
                }
            } else if ("meta".equals(name) && "dtb:uid".equals(metaName = e.getAttribute("name")) && (metaContent = e.getAttribute("content")) != null) {
                this.uid = metaContent;
            }
        }
    }

    @Override
    public void endElement() {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) {
    }

    public String getUid() {
        return this.uid;
    }
}

