/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.propagation;

import java.util.ArrayList;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.propagation.Propagation;
import org.maltparser.core.propagation.spec.PropagationSpec;
import org.maltparser.core.propagation.spec.PropagationSpecs;
import org.maltparser.core.symbol.SymbolTableHandler;
import org.maltparser.core.syntaxgraph.edge.Edge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Propagations {
    private ArrayList<Propagation> propagations;
    private SymbolTableHandler symbolTables;

    public Propagations(PropagationSpecs specs, SymbolTableHandler symbolTables) throws MaltChainedException {
        this.setSymbolTables(symbolTables);
        this.propagations = new ArrayList(specs.size());
        for (PropagationSpec spec : specs) {
            this.propagations.add(new Propagation(spec, symbolTables));
        }
    }

    public void propagate(Edge e) throws MaltChainedException {
        for (Propagation propagation : this.propagations) {
            propagation.propagate(e);
        }
    }

    public SymbolTableHandler getSymbolTables() {
        return this.symbolTables;
    }

    public void setSymbolTables(SymbolTableHandler symbolTables) {
        this.symbolTables = symbolTables;
    }

    public ArrayList<Propagation> getPropagations() {
        return this.propagations;
    }

    public String toString() {
        return "Propagations [propagations=" + this.propagations + "]";
    }
}

