/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.THash;
import gnu.trove.TObjectProcedure;
import java.io.Serializable;

public abstract class TObjectHash
extends THash
implements Serializable {
    protected static final Object REMOVED = new Object();
    protected transient Object[] _set;

    protected int capacity() {
        return this._set.length;
    }

    protected void removeAt(int index) {
        super.removeAt(index);
        this._set[index] = REMOVED;
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new Object[capacity];
        return capacity;
    }

    public boolean forEach(TObjectProcedure procedure) {
        Object[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (set[i] == null || set[i] == REMOVED || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Object obj) {
        return this.index(obj) >= 0;
    }

    protected int index(Object obj) {
        Object[] set = this._set;
        int length = set.length;
        int hash = obj.hashCode() & Integer.MAX_VALUE;
        int index = hash % length;
        Object cur = set[index];
        if (!(cur == null || cur != REMOVED && cur.equals(obj))) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && (cur == REMOVED || !cur.equals(obj)));
        }
        return cur == null ? -1 : index;
    }

    protected int insertionIndex(Object obj) {
        Object[] set = this._set;
        int length = set.length;
        int hash = obj.hashCode() & Integer.MAX_VALUE;
        int index = hash % length;
        Object cur = set[index];
        if (cur == null) {
            return index;
        }
        if (cur.equals(obj)) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        do {
            if ((index -= probe) >= 0) continue;
            index += length;
        } while ((cur = set[index]) != null && cur != REMOVED && !cur.equals(obj));
        if (cur == REMOVED) {
            int firstRemoved = index;
            while (!(cur == null || cur != REMOVED && cur.equals(obj))) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
            return cur != null && cur != REMOVED ? -index - 1 : firstRemoved;
        }
        return cur != null && cur != REMOVED ? -index - 1 : index;
    }

    public TObjectHash() {
    }

    public TObjectHash(int initialCapacity) {
        super(initialCapacity);
    }

    public TObjectHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }
}

