/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.util.Formatter;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.CoordSysEvaluator;
import ucar.nc2.ft.point.standard.TableConfigurer;

public abstract class TableConfigurerImpl
implements TableConfigurer {
    private String convName;
    private String convUsed;

    public String getConvName() {
        return this.convName;
    }

    public void setConvName(String convName) {
        this.convName = convName;
    }

    public String getConvUsed() {
        return this.convUsed;
    }

    public void setConvUsed(String convUsed) {
        this.convUsed = convUsed;
    }

    protected String findNameVariableWithStandardNameAndDimension(NetcdfDataset ds, String standard_name, Dimension outer, Formatter errlog) {
        Variable v = this.findVariableWithStandardNameAndDimension(ds, standard_name, outer, errlog);
        return v == null ? null : v.getShortName();
    }

    protected Variable findVariableWithStandardNameAndDimension(NetcdfDataset ds, String standard_name, Dimension outer, Formatter errlog) {
        for (Variable v : ds.getVariables()) {
            String stdName = ds.findAttValueIgnoreCase(v, "standard_name", null);
            if (stdName == null || !stdName.equals(standard_name)) continue;
            if (v.getRank() > 0 && v.getDimension(0).equals(outer)) {
                return v;
            }
            if (!this.isEffectivelyScaler(v) || outer != null) continue;
            return v;
        }
        return null;
    }

    protected boolean isEffectivelyScaler(Variable v) {
        return v.getRank() == 0 || v.getRank() == 1 && v.getDataType() == DataType.CHAR;
    }

    protected Variable findVariableWithStandardNameAndNotDimension(NetcdfDataset ds, String standard_name, Dimension outer, Formatter errlog) {
        for (Variable v : ds.getVariables()) {
            String stdName = ds.findAttValueIgnoreCase(v, "standard_name", null);
            if (stdName == null || !stdName.equals(standard_name) || v.getRank() <= 0 || v.getDimension(0).equals(outer)) continue;
            return v;
        }
        return null;
    }

    protected String matchAxisTypeAndDimension(NetcdfDataset ds, AxisType type, final Dimension outer) {
        CoordinateAxis var = CoordSysEvaluator.findCoordByType(ds, type, new CoordSysEvaluator.Predicate(){

            public boolean match(CoordinateAxis axis) {
                if (outer == null && axis.getRank() == 0) {
                    return true;
                }
                return outer != null && axis.getRank() == 1 && outer.equals(axis.getDimension(0));
            }
        });
        if (var == null) {
            return null;
        }
        return var.getShortName();
    }

    protected String matchAxisTypeAndDimension(NetcdfDataset ds, AxisType type, final Dimension outer, final Dimension inner) {
        CoordinateAxis var = CoordSysEvaluator.findCoordByType(ds, type, new CoordSysEvaluator.Predicate(){

            public boolean match(CoordinateAxis axis) {
                return axis.getRank() == 2 && outer.equals(axis.getDimension(0)) && inner.equals(axis.getDimension(1));
            }
        });
        if (var == null) {
            return null;
        }
        return var.getShortName();
    }

    protected String matchAxisTypeAndDimension(NetcdfDataset ds, AxisType type, final Dimension outer, final Dimension middle, final Dimension inner) {
        CoordinateAxis var = CoordSysEvaluator.findCoordByType(ds, type, new CoordSysEvaluator.Predicate(){

            public boolean match(CoordinateAxis axis) {
                return axis.getRank() == 3 && outer.equals(axis.getDimension(0)) && middle.equals(axis.getDimension(1)) && inner.equals(axis.getDimension(2));
            }
        });
        if (var == null) {
            return null;
        }
        return var.getShortName();
    }

    protected CoordinateAxis findZAxisNotStationAlt(NetcdfDataset ds) {
        CoordinateAxis z = CoordSysEvaluator.findCoordByType(ds, AxisType.Height, new CoordSysEvaluator.Predicate(){

            public boolean match(CoordinateAxis axis) {
                Attribute stdName = axis.findAttribute("standard_name");
                return stdName == null || !"surface_altitude".equals(stdName.getStringValue());
            }
        });
        if (z != null) {
            return z;
        }
        z = CoordSysEvaluator.findCoordByType(ds, AxisType.Pressure, new CoordSysEvaluator.Predicate(){

            public boolean match(CoordinateAxis axis) {
                Attribute stdName = axis.findAttribute("standard_name");
                return stdName == null || !"surface_altitude".equals(stdName.getStringValue());
            }
        });
        return z;
    }
}

