/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClassConverter
implements Converter {
    public static final ClassConverter INSTANCE = new ClassConverter();

    ClassConverter() {
    }

    @Override
    public Object convert(JSON jSON, JSON.Context context, Object object, Class<?> clazz, Type type) throws Exception {
        Object object2;
        if (object instanceof Map) {
            object = ((Map)object).get(null);
        } else if (object instanceof List) {
            object2 = (List)object;
            Object object3 = object = !object2.isEmpty() ? (Object)object2.get(0) : null;
        }
        if (object instanceof String) {
            object2 = object.toString().trim();
            if (((String)object2).equals("boolean")) {
                return Boolean.TYPE;
            }
            if (((String)object2).equals("byte")) {
                return Byte.TYPE;
            }
            if (((String)object2).equals("short")) {
                return Short.TYPE;
            }
            if (((String)object2).equals("int")) {
                return Integer.TYPE;
            }
            if (((String)object2).equals("long")) {
                return Long.TYPE;
            }
            if (((String)object2).equals("float")) {
                return Float.TYPE;
            }
            if (((String)object2).equals("double")) {
                return Double.TYPE;
            }
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                return classLoader.loadClass(object.toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        if (object != null) {
            throw new UnsupportedOperationException("Cannot convert " + object.getClass() + " to " + type);
        }
        return null;
    }
}

