#
# Patch given file with DATA hunks and print to STDOUT.
#
#
# Patch to:
#   - Fixup includes.
#   - Move to uuconfig.h.
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt;
#print $patch;
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
--- usrcP/uuid/unpack.c	Sun Jan 14 15:29:18 2024
+++ ulib/uuid/unpack.c	Sun Jan 14 15:34:47 2024
@@ -32,10 +32,9 @@
  * %End-Header%
  */
 
-#include "config.h"
-#include <string.h>
-#include "uuidP.h"
-#include <uuid/uuid_types.h>
+#include "uuconfig.h"
+#include "uuid/uuidP.h"
+#include "uuid/uuid_types.h"
 
 void myuuid_unpack(const myuuid_t in, struct myuuid *uu)
 {

