=head1 NAME

SMS::Send::Telenor - SMS::Send driver to send messages via Telenor SMS Pro

=head1 SYNOPSIS

  use SMS::Send;

  # Create a sender
  my $sender = SMS::Send->new('Telenor',
        _login    => 'your_aql_username',
        _password => 'your_aql_password',
  );

  # Send a message
  my $sent = $sender->send_sms(
        text => 'This is a test message',
        to   => '+4612345678',
  );

  if ( $sent ) {
        print "Message sent ok\n";
  } else {
        print "Failed to send message\n";
  }


=head1 DESCRIPTION

A driver for SMS::Send to send SMS text messages via Telenor SMS Pro API

This is not intended to be used directly, but instead called by SMS::Send
(see synopsis above for a basic illustration, and see SMS::Send's documentation
for further information).


=head1 AUTHOR

Eivin Giske Skaaren, <lt>eivin@sysmystic.com<gt>


=head1 COPYRIGHT AND LICENSE

Copyright (C) 2015  by Eivin Giske Skaaren

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.7 or,
at your option, any later version of Perl 5 you may have available.


=cut
