use strict;
use warnings;
use Test::More tests => 68;
use Digest::JH qw(jh_384 jh_384_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::JH->new(384)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            jh_384_hex($data), $digest,
            "jh_384_hex: $len bits of $msg"
        );
        ok(
            jh_384($data) eq pack('H*', $digest),
            "jh_384: $len bits of $msg"
        );
    }

    my $md = Digest::JH->new(384)->add_bits($data, $len)
        ->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

__DATA__
00|604CB69A44994B89D8D25ADE362D7E3304532862ECDE225DFBFF8C76DC9A236754E6C662463B19B7E8D034F3DA0B4B41
00|B7245BD4F3612000C74696913DB4CC770573EB12F7301723A87542EB5D3AA47C4084D520810DC1D7AB2FE98B1FA6FD72
C0|F0E804A62D57CF1BF2F9C090680D0D9095BF7169131C5A70C8F0526B0B33970B2675CBD10A10F97336229B2BE44721E8
C0|20B279EF491A2EC422E5525D0A4F7D38BE53EF13F104380510FB9A5D6B2DB63127C1A43DC6E028A95F80BA897D3099E5
80|9C54A5C37D4036BC0689B9F23F51D7FDD170065AACD7866E37AF84FF444EA68BA17E975320742589867E8FBAC9BED3EF
48|47601CB21218F4274640CA14660FE49D6CF61093314C1B1DD26B3E8B1E706004CA9AF764C3C97E73CA7C0F0C5CDEC61F
50|D4AB1D5CC0A98DA03FD641E8425E02B0706430ECF949EEB67669F32FB8E405F1DFBFE4744BE2AD7698389BAC210474A2
98|29B2A42C49A203CEEF0965210C091982F9218C56EDE299B4F2417361CA87C5218C410DFCC0F27E68249867A54E6C238E
CC|90597BB0E2E9F002B3AAD5D2A823E4B08217AC2D1BCA89B61014B81FD86A4836F4FEDA5EF7E3AB8545C9064BBD0C7506
9800|46C27446C9EAC55F0CF5436F454576E9DA525929B8F60EA653CACB4275C983AB400BA4B3306BF583E99CCD8CC160D521
9D40|E002791FBDE19D0E87702B40734D073AF503FDE19CC14C9997401EB246B5E89A75264A67E73F5067EFBA7D62A7E37E4F
AA80|8FCE7314A59B9B41A23FDE89A914157F5BE4ADD35CBBC779D0DA480DBC97B73C2B9C638D6AD29F597C696D380E20D60E
9830|83E35552571AC4BCD9DC4373B8DAAEC30CA89B548E1996426C47ECAA49C141E5C244379E3FD956A32BC81D793D740F9B
5030|209F513176F946E8DE784700207780629805114181E31C70168516AA2D208DD7BA384EAFB31001FCBBDA12D218A9E3AA
4D24|1A36FD6F766EB9446C4F4EC167A20199BA17E5F7DE84102447C9A97DF247C282E0423B881DEA02BEFDA7FA74FBA55F43
CBDE|F2E1280BB9BE740DF19E3970EEFF820D488DFC154075A910B357313E6FA8E082D6094B387564CEF2947047B7974C514F
41FB|0277C82175EC4B2281B03DC0745CD34BF108AC88E28CA2E3308D98752A36816E7AC13B901B4C537BC4802ED4298EED71
4FF400|DB27AAA36BC2F07D8FA9F536EEF37D10DBE47EE3C4C1BFD161B003F32D73A000DC3B50AD4A707B7CF0DFFFEE0C50982C
FD0440|F690F13FC4D7172B58D571352651B9B7D2EBA62B042DF2F814E4D935FFFC75817578C0292814F6D2139CF58A4AF38CBA
424D00|5A38A68D3DB3903B1D7DC9A9D60E224C6A661EEA1DA8D55CBA5AE96A25EA75A108F7A9F4D765EFED93F5D36615667356
3FDEE0|6D9D156E1A5F70D2A0666FE7EE9784B1C64CCB2B04A659547F9669ACF456F1DF0601215434A088242A6E492ADAB53C30
335768|4685448215C9CC2CE783B5C2CDBC07FCE80533C065383CFE3FF9209F24C43390DDA33FC8304D749EDF22A0867C6B9AEA
051E7C|0EAD12E45833C91FB477FDB20E40A09297CF8CB24C7C5AF219F6C5F11EB117E67F795B50DB5689B75FE2703E57ADAC4E
717F8C|1BA1E77E19B2B12A88247E457A53C492BB43EADAF512FAB6D4EADE16F71CBF3753BFB677A4D6353A7B82D2B1814E1626
1F877C|684C87061B34FCDCA80224DC823D398EC9E04FDFB7C781D65D491CBCE35F097CE13445AD06F649E35A4A2376AB5250E0
EB35CF80|C37EAA4DB1DB6716BFD6D37870ABDA978EDF15B9265D726D2E7A7173C7475B9A072E20D5BF0D7481A81E0BC1D9442349
B406C480|DE4F746E80FE266F28B25322456B8A47D7A1B39A019BD239EFCBFF58A3D7BB6C2A4967CB83ADBCD7599560A89EFB54D0
CEE88040|5ACCFE38F5AFC546D2F1840E87DBED860C6A4A8013BA07BE585DFBE4F0A88CE39AAEB75438D33CDFC0E06503CC79C535
C584DB70|8E1BD051EFD7814F600EDBD1A547D17D10045198C264BCA46AD0ACCF669246CCBF285E7709281ECFF23252DB09A3B574
53587BC8|854BD9A899E7D24E9138EA13B7F757AB239752D9389BEA2B23097D0B960CDA2B42FE5E128DF01296DE22DB5455FC0F6C
69A305B0|8577C0A4F6C2F0EED289D55BB1B32CB9AD2EDA75EB99CB56B058B08937DA3CF49FA00757965C01DDE426256F26330254
C9375ECE|CC42F78F0E496FE810F404193A5F89F29E99C9FBC22D795B50B182D176C736EF70D7C1F23885B0932D67C9FC95477CEE
C1ECFDFC|3CD8FAEB48F8A696965958DB5D51086265D5DD9858D7230D02882B115F0AFC388F988005781E7BA0E5098E842D0B3111
8D73E8A280|4B2A642FC3CB57887581187AE23A203F2586CB5F381269844D1509FC2E93D0285E1E8A399EE61F5E6AD43DB1E6A423D3
06F2522080|E29431BB8D569C90E822F979F8AECFAE3A81B7BC1562C39B2BFBF15D56FCFFBD8A6E56A65DE109FB8A05489669C4486B
3EF6C36F20|B47D9E0B6AE2C154AF73994CA41DDFDF75D31D51D62FC0E2731C50EA1DF23EDBC130B08FD424850228284FD90AA0561A
0127A1D340|2B6B8F529AF8837954AF04F392BB2D803392C18C36DC7B864E2CB6FBBC315FAB1E7496BFA098D023515287CE425517CF
6A6AB6C210|B8074202A7FA49454A5C0D17F5D723D4950E4EA30003C59AA2D4644C4B382C3C8BF56D8881F9DB1608E039C24EC739C0
AF3175E160|46307DA050D606FEB4AD3C7182E19A4C74723B55AA1EC6E675913060B4B8D5B97742379A1AA0BD7D8817A6099AF5C9E7
B66609ED86|5B721E250869FE8DDB140A71FBA17B05CF3272D58FC8CB926D71D31E81C6FEA7EAF6247BFDEC3AC7B3396F8DFA5C44AA
21F134AC57|E7335FF8947F67E0C5FD64E3A25282DFB529118E921362ACEC5E2A54B189F91AEDB984F49BEA3BE2B13E10E2F6964DA5
3DC2AADFFC80|AA14D792FC0D6C47B3E512A9A53F6014DEAE3DFE731617B1B1BD3BAFB1131B5A07DE998885D9BC5C1CD8932993DCC364
9202736D2240|C00F29F2BB2E2D15ECB37A0C2EF1E83F2A4493ADCFF2B4B9B216672C26F6649FCA41A193CA6B53D7E74C2929E40689ED
F219BD629820|451D34DE605F33C21E0B17DD687BBED49FCE088B232D8501382241451F5545FF93538BAE10F25077C92FE05637E34D8D
F3511EE2C4B0|0BD4C61F62B1AF06F7E1185E88A06AE669B807A91954669C5F54464B8D52957367F69DB2C1D2E62B91B8DDE5CE94A026
3ECAB6BF7720|3FAC3275050E27D8B937985F36A68DD98C5BE176C4B76B490D7F90D53D34A293FC7B75BFC4AF3F63B5CB8AC5B5B14F4B
CD62F688F498|A7CB64D406BA2B7AC5E0110B3C02E567634B79DE244ED553447F8EE0FCAEA6E5A74A9AD5616D24962C7BB76108463C31
C2CBAA33A9F8|17535C43FDDFE0350B83ED00FB258BF7DBF76F0B3E754829836F062B115D2D1B02BFF5AF42ED69327C17D59C0023F162
C6F50BB74E29|55F868BFCF083D7CAB818E0486F07B0AE0E35CB6237CA27B18F02BF11DD7ECD187CD5C0BBAAF61337EBA6A7231FB8F32
79F1B4CCC62A00|F17BB655ACAE6BD481E0CD829DEFB0BCF74C9CD9CDDD6506FDD68478CD0CEFC3FFCC57F5FE1F7D0511543AC386EBED5A
