package WebService::Mattermost::V4::API::Resource::Cluster;

# ABSTRACT: Wrapped API methods for the cluster API endpoints.

use Moo;

extends 'WebService::Mattermost::V4::API::Resource';

################################################################################

sub status {
    my $self = shift;

    return $self->_get({ endpoint => 'status' });
}

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Resource::Cluster - Wrapped API methods for the cluster API endpoints.

=head1 VERSION

version 0.29

=head1 DESCRIPTION

=head2 USAGE

    use WebService::Mattermost;

    my $mm = WebService::Mattermost->new({
        authenticate => 1,
        username     => 'email@address.com',
        password     => 'passwordhere',
        base_url     => 'https://my.mattermost.server.com/api/v4/',
    });

    my $cluster = $mm->api->cluster;

=head2 METHODS

=over 4

=item C<status()>

    my $response = $cluster->status;

=back

=head1 SEE ALSO

=over 4

=item L<https://api.mattermost.com/#tag/cluster>

Official "cluster" API documentation.

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
