########################################################################
# test using module with no args (all defaults) for perl version values.
########################################################################
use 5.008;
use strict;
use version;

use Test::More;
use Test::Deep;

use File::Basename  qw( basename    );
use FindBin         qw( $Bin        );

use File::Spec::Functions
qw
(
    &catpath
);

use lib( "$Bin/../../lib", "$Bin/../lib" );
use Test::KwikHaks;

my $madness = 'Module::FromPerlVer';
my $vers_d  = 'version';
my $work_d  = eval { Test::KwikHaks::lib_tmpdir }
or BAIL_OUT "Failed create tmpdir: $@";

*output     = Test::KwikHaks->can( 'output' );

output();
output( "Test sandbox: '$vers_d'" );
my ( $base, $perl_v )  
= eval
{
    Test::KwikHaks::perl_v_from_basename()
}
or BAIL_OUT "Missing Perl Version: $@";

local $ENV{ PERL_VERSION } = $perl_v;

eval
{
    use_ok $madness, work_dir => $work_d;

    1
}
or BAIL_OUT "Use failed: $@";

for my $prefix ( $madness->source_prefix )
{
    is $prefix, $vers_d, "Source prefix: '$prefix' ($vers_d)";
}

for my $found ( scalar $madness->source_files )
{
    @$found
    ? pass 'Found source files in version directory'
    : fail 'Missing source files for cleanup'
    ;

    note "Source files:\n", explain $found;

    for my $item ( @$found )
    {
        my $path    = catpath '', $work_d, $item;

        ok -e $path , "Found: '$item' ($work_d)";
    }
}

eval
{
    $madness->cleanup;

    pass "Survived cleanup.";
}
or 
fail "Failed cleanup: $@";

done_testing;
__END__
