#!/usr/bin/perl

use strict;
use ExtUtils::MakeMaker;
use Config;

my $cc = $Config{cc};
my $inc = '-I/usr/local/include';
for (@ARGV) {
    if (/^CC=(.+)/) {
        $cc = $1;
    }
    elsif (/^INC=(.+)/) {
        $inc = $1;
    }
}
unlink "make_const.c";

WriteMakefile(
    NAME                => 'Y',
    VERSION_FROM        => 'lib/Y.pm',
    DISTNAME            => 'libYperl',
    PREREQ_PM           => { POE => '0.27', WeakRef => 0 },
    ($] >= 5.005 ?
        (ABSTRACT_FROM  => 'lib/Y.pm',
         AUTHOR         => 'Scott Beck <sbeck@gossamer-threads.com>') : ()),
);

# Anyone know a nicer way to do this, let me know
#
open FH, ">make_const.c" or die "open make_const.c: $!";
print FH <DATA>;
close FH;
print "$cc $inc make_const.c -o make_const\n";
system($cc, $inc, 'make_const.c', '-o', 'make_const');
die "Could not compile" if $? >> 8;

print "./make_const\n";
system("./make_const");
die "Could not make constants" if $? >> 8;


__DATA__


#include <stdio.h>
#include <string.h>
#include <Y/const.h>

int main(int argc, char *argv[])
{

    FILE *fh;

    fh = fopen("lib/Y/Constants.pm", "w+");
    if (fh == NULL) {
        perror("open");
        exit(1);
    }
    fprintf(fh, "## Autogenerated from Y/const.h ##\n");
    fprintf(fh, "package Y::Constants;\n\n");

    fprintf(fh, "use strict;\n");
    fprintf(fh, "use vars qw(@ISA @EXPORT_OK %%EXPORT_TAGS @keys @messages @modifiers);\n\n");

    fprintf(fh, "require Exporter;\n");
    fprintf(fh, "@ISA = qw(Exporter);\n\n");
    /* messages */
    fprintf(fh, "sub YMO_NO_OPERATION () { %d }\npush @messages, \"YMO_NO_OPERATION\";\n", YMO_NO_OPERATION);
    fprintf(fh, "sub YMO_ERROR () { %d }\npush @messages, \"YMO_ERROR\";\n", YMO_ERROR);
    fprintf(fh, "sub YMO_QUIT () { %d }\npush @messages, \"YMO_QUIT\";\n", YMO_QUIT);
    fprintf(fh, "sub YMO_EVENT () { %d }\npush @messages, \"YMO_EVENT\";\n", YMO_EVENT);
    fprintf(fh, "sub YMO_INVOKE_SPECIAL () { %d }\npush @messages, \"YMO_INVOKE_SPECIAL\";\n", YMO_INVOKE_SPECIAL);
    fprintf(fh, "sub YMO_SPECIAL_RETURNS () { %d }\npush @messages, \"YMO_SPECIAL_RETURNS\";\n", YMO_SPECIAL_RETURNS);
    fprintf(fh, "sub YMO_FIND_CLASS () { %d }\npush @messages, \"YMO_FIND_CLASS\";\n", YMO_FIND_CLASS);
    fprintf(fh, "sub YMO_FOUND_CLASS () { %d }\npush @messages, \"YMO_FOUND_CLASS\";\n", YMO_FOUND_CLASS);
    fprintf(fh, "sub YMO_INSTANTIATE () { %d }\npush @messages, \"YMO_INSTANTIATE\";\n", YMO_INSTANTIATE);
    fprintf(fh, "sub YMO_NEW_OBJECT () { %d }\npush @messages, \"YMO_NEW_OBJECT\";\n", YMO_NEW_OBJECT);
    fprintf(fh, "sub YMO_INVOKE_METHOD () { %d }\npush @messages, \"YMO_INVOKE_METHOD\";\n", YMO_INVOKE_METHOD);
    fprintf(fh, "sub YMO_METHOD_RETURNS () { %d }\npush @messages, \"YMO_METHOD_RETURNS\";\n", YMO_METHOD_RETURNS);
    fprintf(fh, "sub YMO_GET_PROPERTY () { %d }\npush @messages, \"YMO_GET_PROPERTY\";\n", YMO_GET_PROPERTY);
    fprintf(fh, "sub YMO_GOT_PROPERTY () { %d }\npush @messages, \"YMO_GOT_PROPERTY\";\n", YMO_GOT_PROPERTY);
    fprintf(fh, "sub YMO_SET_PROPERTY () { %d }\npush @messages, \"YMO_SET_PROPERTY\";\n", YMO_SET_PROPERTY);
    fprintf(fh, "sub YMO_SUBSCRIBE_SIGNAL () { %d }\npush @messages, \"YMO_SUBSCRIBE_SIGNAL\";\n", YMO_SUBSCRIBE_SIGNAL);
    fprintf(fh, "sub YMO_LIST_METHODS () { %d }\npush @messages, \"YMO_LIST_METHODS\";\n", YMO_LIST_METHODS);
    fprintf(fh, "sub YMO_METHODS_LISTED () { %d }\npush @messages, \"YMO_METHODS_LISTED\";\n", YMO_METHODS_LISTED);
    fprintf(fh, "sub YMO_LIST_PROPERTIES () { %d }\npush @messages, \"YMO_LIST_PROPERTIES\";\n", YMO_LIST_PROPERTIES);
    fprintf(fh, "sub YMO_PROPERTIES_LISTED () { %d }\npush @messages, \"YMO_PROPERTIES_LISTED\";\n\n", YMO_PROPERTIES_LISTED);

    /* keys */
    fprintf(fh, "sub YK_UNKNOWN () { %d }\npush @keys, \"YK_UNKNOWN\";\n", YK_UNKNOWN);
    fprintf(fh, "sub YK_FIRST () { %d }\npush @keys, \"YK_FIRST\";\n", YK_FIRST);
    fprintf(fh, "sub YK_CTRL_A () { %d }\npush @keys, \"YK_CTRL_A\";\n", YK_CTRL_A);
    fprintf(fh, "sub YK_CTRL_B () { %d }\npush @keys, \"YK_CTRL_B\";\n", YK_CTRL_B);
    fprintf(fh, "sub YK_CTRL_C () { %d }\npush @keys, \"YK_CTRL_C\";\n", YK_CTRL_C);
    fprintf(fh, "sub YK_CTRL_D () { %d }\npush @keys, \"YK_CTRL_D\";\n", YK_CTRL_D);
    fprintf(fh, "sub YK_CTRL_E () { %d }\npush @keys, \"YK_CTRL_E\";\n", YK_CTRL_E);
    fprintf(fh, "sub YK_CTRL_F () { %d }\npush @keys, \"YK_CTRL_F\";\n", YK_CTRL_F);
    fprintf(fh, "sub YK_CTRL_G () { %d }\npush @keys, \"YK_CTRL_G\";\n", YK_CTRL_G);
    fprintf(fh, "sub YK_CTRL_H () { %d }\npush @keys, \"YK_CTRL_H\";\n", YK_CTRL_H);
    fprintf(fh, "sub YK_BACKSPACE () { %d }\npush @keys, \"YK_BACKSPACE\";\n", YK_BACKSPACE);
    fprintf(fh, "sub YK_CTRL_I () { %d }\npush @keys, \"YK_CTRL_I\";\n", YK_CTRL_I);
    fprintf(fh, "sub YK_TAB () { %d }\npush @keys, \"YK_TAB\";\n", YK_TAB);
    fprintf(fh, "sub YK_CTRL_J () { %d }\npush @keys, \"YK_CTRL_J\";\n", YK_CTRL_J);
    fprintf(fh, "sub YK_CTRL_K () { %d }\npush @keys, \"YK_CTRL_K\";\n", YK_CTRL_K);
    fprintf(fh, "sub YK_CTRL_L () { %d }\npush @keys, \"YK_CTRL_L\";\n", YK_CTRL_L);
    fprintf(fh, "sub YK_CLEAR () { %d }\npush @keys, \"YK_CLEAR\";\n", YK_CLEAR);
    fprintf(fh, "sub YK_CTRL_M () { %d }\npush @keys, \"YK_CTRL_M\";\n", YK_CTRL_M);
    fprintf(fh, "sub YK_RETURN () { %d }\npush @keys, \"YK_RETURN\";\n", YK_RETURN);
    fprintf(fh, "sub YK_CTRL_N () { %d }\npush @keys, \"YK_CTRL_N\";\n", YK_CTRL_N);
    fprintf(fh, "sub YK_CTRL_O () { %d }\npush @keys, \"YK_CTRL_O\";\n", YK_CTRL_O);
    fprintf(fh, "sub YK_CTRL_P () { %d }\npush @keys, \"YK_CTRL_P\";\n", YK_CTRL_P);
    fprintf(fh, "sub YK_CTRL_Q () { %d }\npush @keys, \"YK_CTRL_Q\";\n", YK_CTRL_Q);
    fprintf(fh, "sub YK_CTRL_R () { %d }\npush @keys, \"YK_CTRL_R\";\n", YK_CTRL_R);
    fprintf(fh, "sub YK_CTRL_S () { %d }\npush @keys, \"YK_CTRL_S\";\n", YK_CTRL_S);
    fprintf(fh, "sub YK_PAUSE () { %d }\npush @keys, \"YK_PAUSE\";\n", YK_PAUSE);
    fprintf(fh, "sub YK_CTRL_T () { %d }\npush @keys, \"YK_CTRL_T\";\n", YK_CTRL_T);
    fprintf(fh, "sub YK_CTRL_U () { %d }\npush @keys, \"YK_CTRL_U\";\n", YK_CTRL_U);
    fprintf(fh, "sub YK_CTRL_V () { %d }\npush @keys, \"YK_CTRL_V\";\n", YK_CTRL_V);
    fprintf(fh, "sub YK_CTRL_W () { %d }\npush @keys, \"YK_CTRL_W\";\n", YK_CTRL_W);
    fprintf(fh, "sub YK_CTRL_X () { %d }\npush @keys, \"YK_CTRL_X\";\n", YK_CTRL_X);
    fprintf(fh, "sub YK_CTRL_Y () { %d }\npush @keys, \"YK_CTRL_Y\";\n", YK_CTRL_Y);
    fprintf(fh, "sub YK_CTRL_Z () { %d }\npush @keys, \"YK_CTRL_Z\";\n", YK_CTRL_Z);
    fprintf(fh, "sub YK_CTRL_LEFTBRACKET () { %d }\npush @keys, \"YK_CTRL_LEFTBRACKET\";\n", YK_CTRL_LEFTBRACKET);
    fprintf(fh, "sub YK_ESCAPE () { %d }\npush @keys, \"YK_ESCAPE\";\n", YK_ESCAPE);
    fprintf(fh, "sub YK_CTRL_BACKSLASH () { %d }\npush @keys, \"YK_CTRL_BACKSLASH\";\n", YK_CTRL_BACKSLASH);
    fprintf(fh, "sub YK_CTRL_RIGHTBRACKET () { %d }\npush @keys, \"YK_CTRL_RIGHTBRACKET\";\n", YK_CTRL_RIGHTBRACKET);
    fprintf(fh, "sub YK_CTRL_CARET () { %d }\npush @keys, \"YK_CTRL_CARET\";\n", YK_CTRL_CARET);
    fprintf(fh, "sub YK_CTRL_UNDERSCORE () { %d }\npush @keys, \"YK_CTRL_UNDERSCORE\";\n", YK_CTRL_UNDERSCORE);
    fprintf(fh, "sub YK_SPACE () { %d }\npush @keys, \"YK_SPACE\";\n", YK_SPACE);
    fprintf(fh, "sub YK_EXCLAIM () { %d }\npush @keys, \"YK_EXCLAIM\";\n", YK_EXCLAIM);
    fprintf(fh, "sub YK_QUOTEDBL () { %d }\npush @keys, \"YK_QUOTEDBL\";\n", YK_QUOTEDBL);
    fprintf(fh, "sub YK_HASH () { %d }\npush @keys, \"YK_HASH\";\n", YK_HASH);
    fprintf(fh, "sub YK_DOLLAR () { %d }\npush @keys, \"YK_DOLLAR\";\n", YK_DOLLAR);
    fprintf(fh, "sub YK_PERCENT () { %d }\npush @keys, \"YK_PERCENT\";\n", YK_PERCENT);
    fprintf(fh, "sub YK_AMPERSAND () { %d }\npush @keys, \"YK_AMPERSAND\";\n", YK_AMPERSAND);
    fprintf(fh, "sub YK_QUOTE () { %d }\npush @keys, \"YK_QUOTE\";\n", YK_QUOTE);
    fprintf(fh, "sub YK_LEFTPAREN () { %d }\npush @keys, \"YK_LEFTPAREN\";\n", YK_LEFTPAREN);
    fprintf(fh, "sub YK_RIGHTPAREN () { %d }\npush @keys, \"YK_RIGHTPAREN\";\n", YK_RIGHTPAREN);
    fprintf(fh, "sub YK_ASTERISK () { %d }\npush @keys, \"YK_ASTERISK\";\n", YK_ASTERISK);
    fprintf(fh, "sub YK_PLUS () { %d }\npush @keys, \"YK_PLUS\";\n", YK_PLUS);
    fprintf(fh, "sub YK_COMMA () { %d }\npush @keys, \"YK_COMMA\";\n", YK_COMMA);
    fprintf(fh, "sub YK_MINUS () { %d }\npush @keys, \"YK_MINUS\";\n", YK_MINUS);
    fprintf(fh, "sub YK_PERIOD () { %d }\npush @keys, \"YK_PERIOD\";\n", YK_PERIOD);
    fprintf(fh, "sub YK_SLASH () { %d }\npush @keys, \"YK_SLASH\";\n", YK_SLASH);
    fprintf(fh, "sub YK_0 () { %d }\npush @keys, \"YK_0\";\n", YK_0);
    fprintf(fh, "sub YK_1 () { %d }\npush @keys, \"YK_1\";\n", YK_1);
    fprintf(fh, "sub YK_2 () { %d }\npush @keys, \"YK_2\";\n", YK_2);
    fprintf(fh, "sub YK_3 () { %d }\npush @keys, \"YK_3\";\n", YK_3);
    fprintf(fh, "sub YK_4 () { %d }\npush @keys, \"YK_4\";\n", YK_4);
    fprintf(fh, "sub YK_5 () { %d }\npush @keys, \"YK_5\";\n", YK_5);
    fprintf(fh, "sub YK_6 () { %d }\npush @keys, \"YK_6\";\n", YK_6);
    fprintf(fh, "sub YK_7 () { %d }\npush @keys, \"YK_7\";\n", YK_7);
    fprintf(fh, "sub YK_8 () { %d }\npush @keys, \"YK_8\";\n", YK_8);
    fprintf(fh, "sub YK_9 () { %d }\npush @keys, \"YK_9\";\n", YK_9);
    fprintf(fh, "sub YK_COLON () { %d }\npush @keys, \"YK_COLON\";\n", YK_COLON);
    fprintf(fh, "sub YK_SEMICOLON () { %d }\npush @keys, \"YK_SEMICOLON\";\n", YK_SEMICOLON);
    fprintf(fh, "sub YK_LESS () { %d }\npush @keys, \"YK_LESS\";\n", YK_LESS);
    fprintf(fh, "sub YK_EQUALS () { %d }\npush @keys, \"YK_EQUALS\";\n", YK_EQUALS);
    fprintf(fh, "sub YK_GREATER () { %d }\npush @keys, \"YK_GREATER\";\n", YK_GREATER);
    fprintf(fh, "sub YK_QUESTION () { %d }\npush @keys, \"YK_QUESTION\";\n", YK_QUESTION);
    fprintf(fh, "sub YK_AT () { %d }\npush @keys, \"YK_AT\";\n", YK_AT);
    fprintf(fh, "sub YK_A () { %d }\npush @keys, \"YK_A\";\n", YK_A);
    fprintf(fh, "sub YK_B () { %d }\npush @keys, \"YK_B\";\n", YK_B);
    fprintf(fh, "sub YK_C () { %d }\npush @keys, \"YK_C\";\n", YK_C);
    fprintf(fh, "sub YK_D () { %d }\npush @keys, \"YK_D\";\n", YK_D);
    fprintf(fh, "sub YK_E () { %d }\npush @keys, \"YK_E\";\n", YK_E);
    fprintf(fh, "sub YK_F () { %d }\npush @keys, \"YK_F\";\n", YK_F);
    fprintf(fh, "sub YK_G () { %d }\npush @keys, \"YK_G\";\n", YK_G);
    fprintf(fh, "sub YK_H () { %d }\npush @keys, \"YK_H\";\n", YK_H);
    fprintf(fh, "sub YK_I () { %d }\npush @keys, \"YK_I\";\n", YK_I);
    fprintf(fh, "sub YK_J () { %d }\npush @keys, \"YK_J\";\n", YK_J);
    fprintf(fh, "sub YK_K () { %d }\npush @keys, \"YK_K\";\n", YK_K);
    fprintf(fh, "sub YK_L () { %d }\npush @keys, \"YK_L\";\n", YK_L);
    fprintf(fh, "sub YK_M () { %d }\npush @keys, \"YK_M\";\n", YK_M);
    fprintf(fh, "sub YK_N () { %d }\npush @keys, \"YK_N\";\n", YK_N);
    fprintf(fh, "sub YK_O () { %d }\npush @keys, \"YK_O\";\n", YK_O);
    fprintf(fh, "sub YK_P () { %d }\npush @keys, \"YK_P\";\n", YK_P);
    fprintf(fh, "sub YK_Q () { %d }\npush @keys, \"YK_Q\";\n", YK_Q);
    fprintf(fh, "sub YK_R () { %d }\npush @keys, \"YK_R\";\n", YK_R);
    fprintf(fh, "sub YK_S () { %d }\npush @keys, \"YK_S\";\n", YK_S);
    fprintf(fh, "sub YK_T () { %d }\npush @keys, \"YK_T\";\n", YK_T);
    fprintf(fh, "sub YK_U () { %d }\npush @keys, \"YK_U\";\n", YK_U);
    fprintf(fh, "sub YK_V () { %d }\npush @keys, \"YK_V\";\n", YK_V);
    fprintf(fh, "sub YK_W () { %d }\npush @keys, \"YK_W\";\n", YK_W);
    fprintf(fh, "sub YK_X () { %d }\npush @keys, \"YK_X\";\n", YK_X);
    fprintf(fh, "sub YK_Y () { %d }\npush @keys, \"YK_Y\";\n", YK_Y);
    fprintf(fh, "sub YK_Z () { %d }\npush @keys, \"YK_Z\";\n", YK_Z);
    fprintf(fh, "sub YK_LEFTBRACKET () { %d }\npush @keys, \"YK_LEFTBRACKET\";\n", YK_LEFTBRACKET);
    fprintf(fh, "sub YK_BACKSLASH () { %d }\npush @keys, \"YK_BACKSLASH\";\n", YK_BACKSLASH);
    fprintf(fh, "sub YK_RIGHTBRACKET () { %d }\npush @keys, \"YK_RIGHTBRACKET\";\n", YK_RIGHTBRACKET);
    fprintf(fh, "sub YK_CARET () { %d }\npush @keys, \"YK_CARET\";\n", YK_CARET);
    fprintf(fh, "sub YK_UNDERSCORE () { %d }\npush @keys, \"YK_UNDERSCORE\";\n", YK_UNDERSCORE);
    fprintf(fh, "sub YK_BACKQUOTE () { %d }\npush @keys, \"YK_BACKQUOTE\";\n", YK_BACKQUOTE);
    fprintf(fh, "sub YK_a () { %d }\npush @keys, \"YK_a\";\n", YK_a);
    fprintf(fh, "sub YK_b () { %d }\npush @keys, \"YK_b\";\n", YK_b);
    fprintf(fh, "sub YK_c () { %d }\npush @keys, \"YK_c\";\n", YK_c);
    fprintf(fh, "sub YK_d () { %d }\npush @keys, \"YK_d\";\n", YK_d);
    fprintf(fh, "sub YK_e () { %d }\npush @keys, \"YK_e\";\n", YK_e);
    fprintf(fh, "sub YK_f () { %d }\npush @keys, \"YK_f\";\n", YK_f);
    fprintf(fh, "sub YK_g () { %d }\npush @keys, \"YK_g\";\n", YK_g);
    fprintf(fh, "sub YK_h () { %d }\npush @keys, \"YK_h\";\n", YK_h);
    fprintf(fh, "sub YK_i () { %d }\npush @keys, \"YK_i\";\n", YK_i);
    fprintf(fh, "sub YK_j () { %d }\npush @keys, \"YK_j\";\n", YK_j);
    fprintf(fh, "sub YK_k () { %d }\npush @keys, \"YK_k\";\n", YK_k);
    fprintf(fh, "sub YK_l () { %d }\npush @keys, \"YK_l\";\n", YK_l);
    fprintf(fh, "sub YK_m () { %d }\npush @keys, \"YK_m\";\n", YK_m);
    fprintf(fh, "sub YK_n () { %d }\npush @keys, \"YK_n\";\n", YK_n);
    fprintf(fh, "sub YK_o () { %d }\npush @keys, \"YK_o\";\n", YK_o);
    fprintf(fh, "sub YK_p () { %d }\npush @keys, \"YK_p\";\n", YK_p);
    fprintf(fh, "sub YK_q () { %d }\npush @keys, \"YK_q\";\n", YK_q);
    fprintf(fh, "sub YK_r () { %d }\npush @keys, \"YK_r\";\n", YK_r);
    fprintf(fh, "sub YK_s () { %d }\npush @keys, \"YK_s\";\n", YK_s);
    fprintf(fh, "sub YK_t () { %d }\npush @keys, \"YK_t\";\n", YK_t);
    fprintf(fh, "sub YK_u () { %d }\npush @keys, \"YK_u\";\n", YK_u);
    fprintf(fh, "sub YK_v () { %d }\npush @keys, \"YK_v\";\n", YK_v);
    fprintf(fh, "sub YK_w () { %d }\npush @keys, \"YK_w\";\n", YK_w);
    fprintf(fh, "sub YK_x () { %d }\npush @keys, \"YK_x\";\n", YK_x);
    fprintf(fh, "sub YK_y () { %d }\npush @keys, \"YK_y\";\n", YK_y);
    fprintf(fh, "sub YK_z () { %d }\npush @keys, \"YK_z\";\n", YK_z);
    fprintf(fh, "sub YK_LEFTBRACE () { %d }\npush @keys, \"YK_LEFTBRACE\";\n", YK_LEFTBRACE);
    fprintf(fh, "sub YK_PIPE () { %d }\npush @keys, \"YK_PIPE\";\n", YK_PIPE);
    fprintf(fh, "sub YK_RIGHTBRACE () { %d }\npush @keys, \"YK_RIGHTBRACE\";\n", YK_RIGHTBRACE);
    fprintf(fh, "sub YK_TILDE () { %d }\npush @keys, \"YK_TILDE\";\n", YK_TILDE);
    fprintf(fh, "sub YK_DELETE () { %d }\npush @keys, \"YK_DELETE\";\n\n", YK_DELETE);

    fprintf(fh, "sub YK_WORLD_0 () { %d }\npush @keys, \"YK_WORLD_0\";\n", YK_WORLD_0);
    fprintf(fh, "sub YK_WORLD_1 () { %d }\npush @keys, \"YK_WORLD_1\";\n", YK_WORLD_1);
    fprintf(fh, "sub YK_WORLD_2 () { %d }\npush @keys, \"YK_WORLD_2\";\n", YK_WORLD_2);
    fprintf(fh, "sub YK_WORLD_3 () { %d }\npush @keys, \"YK_WORLD_3\";\n", YK_WORLD_3);
    fprintf(fh, "sub YK_WORLD_4 () { %d }\npush @keys, \"YK_WORLD_4\";\n", YK_WORLD_4);
    fprintf(fh, "sub YK_WORLD_5 () { %d }\npush @keys, \"YK_WORLD_5\";\n", YK_WORLD_5);
    fprintf(fh, "sub YK_WORLD_6 () { %d }\npush @keys, \"YK_WORLD_6\";\n", YK_WORLD_6);
    fprintf(fh, "sub YK_WORLD_7 () { %d }\npush @keys, \"YK_WORLD_7\";\n", YK_WORLD_7);
    fprintf(fh, "sub YK_WORLD_8 () { %d }\npush @keys, \"YK_WORLD_8\";\n", YK_WORLD_8);
    fprintf(fh, "sub YK_WORLD_9 () { %d }\npush @keys, \"YK_WORLD_9\";\n", YK_WORLD_9);
    fprintf(fh, "sub YK_WORLD_10 () { %d }\npush @keys, \"YK_WORLD_10\";\n", YK_WORLD_10);
    fprintf(fh, "sub YK_WORLD_11 () { %d }\npush @keys, \"YK_WORLD_11\";\n", YK_WORLD_11);
    fprintf(fh, "sub YK_WORLD_12 () { %d }\npush @keys, \"YK_WORLD_12\";\n", YK_WORLD_12);
    fprintf(fh, "sub YK_WORLD_13 () { %d }\npush @keys, \"YK_WORLD_13\";\n", YK_WORLD_13);
    fprintf(fh, "sub YK_WORLD_14 () { %d }\npush @keys, \"YK_WORLD_14\";\n", YK_WORLD_14);
    fprintf(fh, "sub YK_WORLD_15 () { %d }\npush @keys, \"YK_WORLD_15\";\n", YK_WORLD_15);
    fprintf(fh, "sub YK_WORLD_16 () { %d }\npush @keys, \"YK_WORLD_16\";\n", YK_WORLD_16);
    fprintf(fh, "sub YK_WORLD_17 () { %d }\npush @keys, \"YK_WORLD_17\";\n", YK_WORLD_17);
    fprintf(fh, "sub YK_WORLD_18 () { %d }\npush @keys, \"YK_WORLD_18\";\n", YK_WORLD_18);
    fprintf(fh, "sub YK_WORLD_19 () { %d }\npush @keys, \"YK_WORLD_19\";\n", YK_WORLD_19);
    fprintf(fh, "sub YK_WORLD_20 () { %d }\npush @keys, \"YK_WORLD_20\";\n", YK_WORLD_20);
    fprintf(fh, "sub YK_WORLD_21 () { %d }\npush @keys, \"YK_WORLD_21\";\n", YK_WORLD_21);
    fprintf(fh, "sub YK_WORLD_22 () { %d }\npush @keys, \"YK_WORLD_22\";\n", YK_WORLD_22);
    fprintf(fh, "sub YK_WORLD_23 () { %d }\npush @keys, \"YK_WORLD_23\";\n", YK_WORLD_23);
    fprintf(fh, "sub YK_WORLD_24 () { %d }\npush @keys, \"YK_WORLD_24\";\n", YK_WORLD_24);
    fprintf(fh, "sub YK_WORLD_25 () { %d }\npush @keys, \"YK_WORLD_25\";\n", YK_WORLD_25);
    fprintf(fh, "sub YK_WORLD_26 () { %d }\npush @keys, \"YK_WORLD_26\";\n", YK_WORLD_26);
    fprintf(fh, "sub YK_WORLD_27 () { %d }\npush @keys, \"YK_WORLD_27\";\n", YK_WORLD_27);
    fprintf(fh, "sub YK_WORLD_28 () { %d }\npush @keys, \"YK_WORLD_28\";\n", YK_WORLD_28);
    fprintf(fh, "sub YK_WORLD_29 () { %d }\npush @keys, \"YK_WORLD_29\";\n", YK_WORLD_29);
    fprintf(fh, "sub YK_WORLD_30 () { %d }\npush @keys, \"YK_WORLD_30\";\n", YK_WORLD_30);
    fprintf(fh, "sub YK_WORLD_31 () { %d }\npush @keys, \"YK_WORLD_31\";\n", YK_WORLD_31);
    fprintf(fh, "sub YK_WORLD_32 () { %d }\npush @keys, \"YK_WORLD_32\";\n", YK_WORLD_32);
    fprintf(fh, "sub YK_WORLD_33 () { %d }\npush @keys, \"YK_WORLD_33\";\n", YK_WORLD_33);
    fprintf(fh, "sub YK_WORLD_34 () { %d }\npush @keys, \"YK_WORLD_34\";\n", YK_WORLD_34);
    fprintf(fh, "sub YK_WORLD_35 () { %d }\npush @keys, \"YK_WORLD_35\";\n", YK_WORLD_35);
    fprintf(fh, "sub YK_WORLD_36 () { %d }\npush @keys, \"YK_WORLD_36\";\n", YK_WORLD_36);
    fprintf(fh, "sub YK_WORLD_37 () { %d }\npush @keys, \"YK_WORLD_37\";\n", YK_WORLD_37);
    fprintf(fh, "sub YK_WORLD_38 () { %d }\npush @keys, \"YK_WORLD_38\";\n", YK_WORLD_38);
    fprintf(fh, "sub YK_WORLD_39 () { %d }\npush @keys, \"YK_WORLD_39\";\n", YK_WORLD_39);
    fprintf(fh, "sub YK_WORLD_40 () { %d }\npush @keys, \"YK_WORLD_40\";\n", YK_WORLD_40);
    fprintf(fh, "sub YK_WORLD_41 () { %d }\npush @keys, \"YK_WORLD_41\";\n", YK_WORLD_41);
    fprintf(fh, "sub YK_WORLD_42 () { %d }\npush @keys, \"YK_WORLD_42\";\n", YK_WORLD_42);
    fprintf(fh, "sub YK_WORLD_43 () { %d }\npush @keys, \"YK_WORLD_43\";\n", YK_WORLD_43);
    fprintf(fh, "sub YK_WORLD_44 () { %d }\npush @keys, \"YK_WORLD_44\";\n", YK_WORLD_44);
    fprintf(fh, "sub YK_WORLD_45 () { %d }\npush @keys, \"YK_WORLD_45\";\n", YK_WORLD_45);
    fprintf(fh, "sub YK_WORLD_46 () { %d }\npush @keys, \"YK_WORLD_46\";\n", YK_WORLD_46);
    fprintf(fh, "sub YK_WORLD_47 () { %d }\npush @keys, \"YK_WORLD_47\";\n", YK_WORLD_47);
    fprintf(fh, "sub YK_WORLD_48 () { %d }\npush @keys, \"YK_WORLD_48\";\n", YK_WORLD_48);
    fprintf(fh, "sub YK_WORLD_49 () { %d }\npush @keys, \"YK_WORLD_49\";\n", YK_WORLD_49);
    fprintf(fh, "sub YK_WORLD_50 () { %d }\npush @keys, \"YK_WORLD_50\";\n", YK_WORLD_50);
    fprintf(fh, "sub YK_WORLD_51 () { %d }\npush @keys, \"YK_WORLD_51\";\n", YK_WORLD_51);
    fprintf(fh, "sub YK_WORLD_52 () { %d }\npush @keys, \"YK_WORLD_52\";\n", YK_WORLD_52);
    fprintf(fh, "sub YK_WORLD_53 () { %d }\npush @keys, \"YK_WORLD_53\";\n", YK_WORLD_53);
    fprintf(fh, "sub YK_WORLD_54 () { %d }\npush @keys, \"YK_WORLD_54\";\n", YK_WORLD_54);
    fprintf(fh, "sub YK_WORLD_55 () { %d }\npush @keys, \"YK_WORLD_55\";\n", YK_WORLD_55);
    fprintf(fh, "sub YK_WORLD_56 () { %d }\npush @keys, \"YK_WORLD_56\";\n", YK_WORLD_56);
    fprintf(fh, "sub YK_WORLD_57 () { %d }\npush @keys, \"YK_WORLD_57\";\n", YK_WORLD_57);
    fprintf(fh, "sub YK_WORLD_58 () { %d }\npush @keys, \"YK_WORLD_58\";\n", YK_WORLD_58);
    fprintf(fh, "sub YK_WORLD_59 () { %d }\npush @keys, \"YK_WORLD_59\";\n", YK_WORLD_59);
    fprintf(fh, "sub YK_WORLD_60 () { %d }\npush @keys, \"YK_WORLD_60\";\n", YK_WORLD_60);
    fprintf(fh, "sub YK_WORLD_61 () { %d }\npush @keys, \"YK_WORLD_61\";\n", YK_WORLD_61);
    fprintf(fh, "sub YK_WORLD_62 () { %d }\npush @keys, \"YK_WORLD_62\";\n", YK_WORLD_62);
    fprintf(fh, "sub YK_WORLD_63 () { %d }\npush @keys, \"YK_WORLD_63\";\n", YK_WORLD_63);
    fprintf(fh, "sub YK_WORLD_64 () { %d }\npush @keys, \"YK_WORLD_64\";\n", YK_WORLD_64);
    fprintf(fh, "sub YK_WORLD_65 () { %d }\npush @keys, \"YK_WORLD_65\";\n", YK_WORLD_65);
    fprintf(fh, "sub YK_WORLD_66 () { %d }\npush @keys, \"YK_WORLD_66\";\n", YK_WORLD_66);
    fprintf(fh, "sub YK_WORLD_67 () { %d }\npush @keys, \"YK_WORLD_67\";\n", YK_WORLD_67);
    fprintf(fh, "sub YK_WORLD_68 () { %d }\npush @keys, \"YK_WORLD_68\";\n", YK_WORLD_68);
    fprintf(fh, "sub YK_WORLD_69 () { %d }\npush @keys, \"YK_WORLD_69\";\n", YK_WORLD_69);
    fprintf(fh, "sub YK_WORLD_70 () { %d }\npush @keys, \"YK_WORLD_70\";\n", YK_WORLD_70);
    fprintf(fh, "sub YK_WORLD_71 () { %d }\npush @keys, \"YK_WORLD_71\";\n", YK_WORLD_71);
    fprintf(fh, "sub YK_WORLD_72 () { %d }\npush @keys, \"YK_WORLD_72\";\n", YK_WORLD_72);
    fprintf(fh, "sub YK_WORLD_73 () { %d }\npush @keys, \"YK_WORLD_73\";\n", YK_WORLD_73);
    fprintf(fh, "sub YK_WORLD_74 () { %d }\npush @keys, \"YK_WORLD_74\";\n", YK_WORLD_74);
    fprintf(fh, "sub YK_WORLD_75 () { %d }\npush @keys, \"YK_WORLD_75\";\n", YK_WORLD_75);
    fprintf(fh, "sub YK_WORLD_76 () { %d }\npush @keys, \"YK_WORLD_76\";\n", YK_WORLD_76);
    fprintf(fh, "sub YK_WORLD_77 () { %d }\npush @keys, \"YK_WORLD_77\";\n", YK_WORLD_77);
    fprintf(fh, "sub YK_WORLD_78 () { %d }\npush @keys, \"YK_WORLD_78\";\n", YK_WORLD_78);
    fprintf(fh, "sub YK_WORLD_79 () { %d }\npush @keys, \"YK_WORLD_79\";\n", YK_WORLD_79);
    fprintf(fh, "sub YK_WORLD_80 () { %d }\npush @keys, \"YK_WORLD_80\";\n", YK_WORLD_80);
    fprintf(fh, "sub YK_WORLD_81 () { %d }\npush @keys, \"YK_WORLD_81\";\n", YK_WORLD_81);
    fprintf(fh, "sub YK_WORLD_82 () { %d }\npush @keys, \"YK_WORLD_82\";\n", YK_WORLD_82);
    fprintf(fh, "sub YK_WORLD_83 () { %d }\npush @keys, \"YK_WORLD_83\";\n", YK_WORLD_83);
    fprintf(fh, "sub YK_WORLD_84 () { %d }\npush @keys, \"YK_WORLD_84\";\n", YK_WORLD_84);
    fprintf(fh, "sub YK_WORLD_85 () { %d }\npush @keys, \"YK_WORLD_85\";\n", YK_WORLD_85);
    fprintf(fh, "sub YK_WORLD_86 () { %d }\npush @keys, \"YK_WORLD_86\";\n", YK_WORLD_86);
    fprintf(fh, "sub YK_WORLD_87 () { %d }\npush @keys, \"YK_WORLD_87\";\n", YK_WORLD_87);
    fprintf(fh, "sub YK_WORLD_88 () { %d }\npush @keys, \"YK_WORLD_88\";\n", YK_WORLD_88);
    fprintf(fh, "sub YK_WORLD_89 () { %d }\npush @keys, \"YK_WORLD_89\";\n", YK_WORLD_89);
    fprintf(fh, "sub YK_WORLD_90 () { %d }\npush @keys, \"YK_WORLD_90\";\n", YK_WORLD_90);
    fprintf(fh, "sub YK_WORLD_91 () { %d }\npush @keys, \"YK_WORLD_91\";\n", YK_WORLD_91);
    fprintf(fh, "sub YK_WORLD_92 () { %d }\npush @keys, \"YK_WORLD_92\";\n", YK_WORLD_92);
    fprintf(fh, "sub YK_WORLD_93 () { %d }\npush @keys, \"YK_WORLD_93\";\n", YK_WORLD_93);
    fprintf(fh, "sub YK_WORLD_94 () { %d }\npush @keys, \"YK_WORLD_94\";\n", YK_WORLD_94);
    fprintf(fh, "sub YK_WORLD_95 () { %d }\npush @keys, \"YK_WORLD_95\";\n\n", YK_WORLD_95);

    fprintf(fh, "sub YK_KP0 () { %d }\npush @keys, \"YK_KP0\";\n", YK_KP0);
    fprintf(fh, "sub YK_KP1 () { %d }\npush @keys, \"YK_KP1\";\n", YK_KP1);
    fprintf(fh, "sub YK_KP2 () { %d }\npush @keys, \"YK_KP2\";\n", YK_KP2);
    fprintf(fh, "sub YK_KP3 () { %d }\npush @keys, \"YK_KP3\";\n", YK_KP3);
    fprintf(fh, "sub YK_KP4 () { %d }\npush @keys, \"YK_KP4\";\n", YK_KP4);
    fprintf(fh, "sub YK_KP5 () { %d }\npush @keys, \"YK_KP5\";\n", YK_KP5);
    fprintf(fh, "sub YK_KP6 () { %d }\npush @keys, \"YK_KP6\";\n", YK_KP6);
    fprintf(fh, "sub YK_KP7 () { %d }\npush @keys, \"YK_KP7\";\n", YK_KP7);
    fprintf(fh, "sub YK_KP8 () { %d }\npush @keys, \"YK_KP8\";\n", YK_KP8);
    fprintf(fh, "sub YK_KP9 () { %d }\npush @keys, \"YK_KP9\";\n", YK_KP9);
    fprintf(fh, "sub YK_KP_PERIOD () { %d }\npush @keys, \"YK_KP_PERIOD\";\n", YK_KP_PERIOD);
    fprintf(fh, "sub YK_KP_DIVIDE () { %d }\npush @keys, \"YK_KP_DIVIDE\";\n", YK_KP_DIVIDE);
    fprintf(fh, "sub YK_KP_MULTIPLY () { %d }\npush @keys, \"YK_KP_MULTIPLY\";\n", YK_KP_MULTIPLY);
    fprintf(fh, "sub YK_KP_MINUS () { %d }\npush @keys, \"YK_KP_MINUS\";\n", YK_KP_MINUS);
    fprintf(fh, "sub YK_KP_PLUS () { %d }\npush @keys, \"YK_KP_PLUS\";\n", YK_KP_PLUS);
    fprintf(fh, "sub YK_KP_ENTER () { %d }\npush @keys, \"YK_KP_ENTER\";\n", YK_KP_ENTER);
    fprintf(fh, "sub YK_KP_EQUALS () { %d }\npush @keys, \"YK_KP_EQUALS\";\n\n", YK_KP_EQUALS);

    fprintf(fh, "sub YK_UP () { %d }\npush @keys, \"YK_UP\";\n", YK_UP);
    fprintf(fh, "sub YK_DOWN () { %d }\npush @keys, \"YK_DOWN\";\n", YK_DOWN);
    fprintf(fh, "sub YK_RIGHT () { %d }\npush @keys, \"YK_RIGHT\";\n", YK_RIGHT);
    fprintf(fh, "sub YK_LEFT () { %d }\npush @keys, \"YK_LEFT\";\n", YK_LEFT);
    fprintf(fh, "sub YK_INSERT () { %d }\npush @keys, \"YK_INSERT\";\n", YK_INSERT);
    fprintf(fh, "sub YK_HOME () { %d }\npush @keys, \"YK_HOME\";\n", YK_HOME);
    fprintf(fh, "sub YK_END () { %d }\npush @keys, \"YK_END\";\n", YK_END);
    fprintf(fh, "sub YK_PAGEUP () { %d }\npush @keys, \"YK_PAGEUP\";\n", YK_PAGEUP);
    fprintf(fh, "sub YK_PAGEDOWN () { %d }\npush @keys, \"YK_PAGEDOWN\";\n\n", YK_PAGEDOWN);

    fprintf(fh, "sub YK_F1 () { %d }\npush @keys, \"YK_F1\";\n", YK_F1);
    fprintf(fh, "sub YK_F2 () { %d }\npush @keys, \"YK_F2\";\n", YK_F2);
    fprintf(fh, "sub YK_F3 () { %d }\npush @keys, \"YK_F3\";\n", YK_F3);
    fprintf(fh, "sub YK_F4 () { %d }\npush @keys, \"YK_F4\";\n", YK_F4);
    fprintf(fh, "sub YK_F5 () { %d }\npush @keys, \"YK_F5\";\n", YK_F5);
    fprintf(fh, "sub YK_F6 () { %d }\npush @keys, \"YK_F6\";\n", YK_F6);
    fprintf(fh, "sub YK_F7 () { %d }\npush @keys, \"YK_F7\";\n", YK_F7);
    fprintf(fh, "sub YK_F8 () { %d }\npush @keys, \"YK_F8\";\n", YK_F8);
    fprintf(fh, "sub YK_F9 () { %d }\npush @keys, \"YK_F9\";\n", YK_F9);
    fprintf(fh, "sub YK_F10 () { %d }\npush @keys, \"YK_F10\";\n", YK_F10);
    fprintf(fh, "sub YK_F11 () { %d }\npush @keys, \"YK_F11\";\n", YK_F11);
    fprintf(fh, "sub YK_F12 () { %d }\npush @keys, \"YK_F12\";\n", YK_F12);
    fprintf(fh, "sub YK_F13 () { %d }\npush @keys, \"YK_F13\";\n", YK_F13);
    fprintf(fh, "sub YK_F14 () { %d }\npush @keys, \"YK_F14\";\n", YK_F14);
    fprintf(fh, "sub YK_F15 () { %d }\npush @keys, \"YK_F15\";\n\n", YK_F15);

    fprintf(fh, "sub YK_NUMLOCK () { %d }\npush @keys, \"YK_NUMLOCK\";\n", YK_NUMLOCK);
    fprintf(fh, "sub YK_CAPSLOCK () { %d }\npush @keys, \"YK_CAPSLOCK\";\n", YK_CAPSLOCK);
    fprintf(fh, "sub YK_SCROLLLOCK () { %d }\npush @keys, \"YK_SCROLLLOCK\";\n", YK_SCROLLLOCK);
    fprintf(fh, "sub YK_RSHIFT () { %d }\npush @keys, \"YK_RSHIFT\";\n", YK_RSHIFT);
    fprintf(fh, "sub YK_LSHIFT () { %d }\npush @keys, \"YK_LSHIFT\";\n", YK_LSHIFT);
    fprintf(fh, "sub YK_RCTRL () { %d }\npush @keys, \"YK_RCTRL\";\n", YK_RCTRL);
    fprintf(fh, "sub YK_LCTRL () { %d }\npush @keys, \"YK_LCTRL\";\n", YK_LCTRL);
    fprintf(fh, "sub YK_RALT () { %d }\npush @keys, \"YK_RALT\";\n", YK_RALT);
    fprintf(fh, "sub YK_LALT () { %d }\npush @keys, \"YK_LALT\";\n", YK_LALT);
    fprintf(fh, "sub YK_RMETA () { %d }\npush @keys, \"YK_RMETA\";\n", YK_RMETA);
    fprintf(fh, "sub YK_LMETA () { %d }\npush @keys, \"YK_LMETA\";\n", YK_LMETA);
    fprintf(fh, "sub YK_LSUPER () { %d }\npush @keys, \"YK_LSUPER\";\n", YK_LSUPER);
    fprintf(fh, "sub YK_RSUPER () { %d }\npush @keys, \"YK_RSUPER\";\n", YK_RSUPER);
    fprintf(fh, "sub YK_MODE () { %d }\npush @keys, \"YK_MODE\";\n", YK_MODE);
    fprintf(fh, "sub YK_COMPOSE () { %d }\npush @keys, \"YK_COMPOSE\";\n\n", YK_COMPOSE);

    fprintf(fh, "sub YK_HELP () { %d }\npush @keys, \"YK_HELP\";\n", YK_HELP);
    fprintf(fh, "sub YK_PRINT () { %d }\npush @keys, \"YK_PRINT\";\n", YK_PRINT);
    fprintf(fh, "sub YK_SYSREQ () { %d }\npush @keys, \"YK_SYSREQ\";\n", YK_SYSREQ);
    fprintf(fh, "sub YK_BREAK () { %d }\npush @keys, \"YK_BREAK\";\n", YK_BREAK);
    fprintf(fh, "sub YK_MENU () { %d }\npush @keys, \"YK_MENU\";\n", YK_MENU);
    fprintf(fh, "sub YK_POWER () { %d }\npush @keys, \"YK_POWER\";\n", YK_POWER);
    fprintf(fh, "sub YK_EURO () { %d }\npush @keys, \"YK_EURO\";\n\n", YK_EURO);

    fprintf(fh, "sub YK_LAS () { %d }\npush @keys, \"YK_LAS\";\n\n", YK_LAST);

    /* Modifiers */
    fprintf(fh, "sub YMOD_NONE () { %d }\npush @modifiers, \"YMOD_NONE\";\n", YMOD_NONE);
    fprintf(fh, "sub YMOD_SHIFT () { %d }\npush @modifiers, \"YMOD_SHIFT\";\n", YMOD_SHIFT);
    fprintf(fh, "sub YMOD_CTRL () { %d }\npush @modifiers, \"YMOD_CTRL\";\n", YMOD_CTRL);
    fprintf(fh, "sub YMOD_ALT () { %d }\npush @modifiers, \"YMOD_ALT\";\n", YMOD_ALT);
    fprintf(fh, "sub YMOD_META () { %d }\npush @modifiers, \"YMOD_META\";\n", YMOD_META);
    fprintf(fh, "sub YMOD_MODE () { %d }\npush @modifiers, \"YMOD_MODE\";\n", YMOD_MODE);
    fprintf(fh, "sub YMOD_NUMLOCK () { %d }\npush @modifiers, \"YMOD_NUMLOCK\";\n\n", YMOD_NUMLOCK);

    fprintf(fh, "%%EXPORT_TAGS = (\n");
    fprintf(fh, "    all       => [@messages, @keys, @modifiers],\n");
    fprintf(fh, "    messages  => \\@messages,\n");
    fprintf(fh, "    modifiers => \\@modifiers,\n");
    fprintf(fh, "    keys      => \\@keys,\n");
    fprintf(fh, ");\n");
    fprintf(fh, "@EXPORT_OK = (@messages, @keys, @modifiers);\n\n");
    fprintf(fh, "1;\n\n__END__\n\n");

    fclose(fh);

    return 0;
}


