package Pcore::App::Controller::ExtJS::App;

use Pcore -role, -result;
use Pcore::Util::Text qw[mark_raw];
use Pcore::Util::Data qw[to_json];
use Pcore::Share::WWW;
use WWW::CDN;

with qw[Pcore::App::Controller::ExtJS];

requires qw[ext_class_viewport];

has extjs_ver                   => ( is => 'ro', isa => Str, default => $WWW::CDN::LATEST_VERION->{extjs} );    # ExtJS framewrok version
has extjs_default_theme_classic => ( is => 'ro', isa => Str, default => 'triton' );
has extjs_default_theme_modern  => ( is => 'ro', isa => Str, default => 'triton' );
has extjs_default_locale        => ( is => 'ro', isa => Str, default => 'en' );
has extjs_app_title             => ( is => 'ro', isa => Str, default => sub { ref $_[0] } );

# TODO fix ExtJS overrides version
around run => sub ( $orig, $self, $req ) {

    # if path tail is not empty - fallback to the original method
    if ( $req->{path_tail} ) {
        $self->$orig($req);

        return;
    }

    my $resources = [];

    # FontAwesome
    push $resources->@*, WWW::CDN->fontawesome;

    # ExtJS framework
    my $devel     = $req->{env}->{QUERY_STRING} =~ /\bdevel\b/sm;
    my $ver       = $self->extjs_ver;
    my $framework = 'classic';

    my $extjs_resources;

    # get theme from query
    if ( $req->{env}->{QUERY_STRING} =~ /\btheme=([a-z-]+)/sm ) {
        my $theme = $1;

        $extjs_resources = WWW::CDN->extjs( $ver, $framework, $theme, $devel );
    }

    # fallback to the default theme
    if ( !$extjs_resources ) {
        my $theme = $framework eq 'classic' ? $self->extjs_default_theme_classic : $self->extjs_default_theme_modern;

        $extjs_resources = WWW::CDN->extjs( $ver, $framework, $theme, $devel );
    }

    push $resources->@*, $extjs_resources->@*;

    # ExtJS locale
    my $locale = $self->extjs_default_locale;

    push $resources->@*, WWW::CDN->extjs_locale( $ver, $framework, $locale, $devel );

    # ExtJS overrides
    push $resources->@*, q[<script type="text/javascript" src="/static/extjs/pcore/overrides-v6.js"></script>];

    my $loader_path = {
        q[*]                       => q[.],
        Ext                        => '/static/extjs/src/',
        'Ext.ux'                   => '/static/extjs/ux/',
        Pcore                      => '/static/extjs/pcore/',
        $self->{ext_app_namespace} => $self->{path},
    };

    $req->authenticate(
        sub ($auth) {
            $auth->extdirect_map(
                undef,
                sub ($api_map) {
                    my $data = {
                        INDEX     => { title => $self->extjs_app_title },
                        resources => $resources,
                        ext       => {
                            api_map => $api_map ? to_json($api_map)->$* : undef,
                            loader_path    => mark_raw( to_json( $loader_path, readable => $devel )->$* ),
                            app_namespace  => $self->{ext_app_namespace},
                            viewport_class => "$self->{ext_app_namespace}.Viewport",
                        },
                    };

                    my $index = P->tmpl->render( 'extjs/index.html', $data );

                    $req->( 200, [ 'Content-Type' => 'text/html; charset=UTF-8' ], $index )->finish;

                    return;
                }
            );

            return;
        }
    );

    return;
};

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
## | Sev. | Lines                | Policy                                                                                                         |
## |======+======================+================================================================================================================|
## |    1 | 42                   | RegularExpressions::ProhibitEnumeratedClasses - Use named character classes ([a-z] vs. [[:lower:]])            |
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::App::Controller::ExtJS::App - ExtJS application HTTP controller

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 ATTRIBUTES

=head1 METHODS

=head1 SEE ALSO

=cut
