package Pcore::DBD::Builder::MySQL;

use Pcore qw[-class];

extends qw[Pcore::DBD::Builder];

our $CONTEXT_KEYWORDS = {    #
    'ON DUPLICATE KEY UPDATE' => '_sql_set',
};

around get_context_keywords => sub {
    my $orig = shift;
    my $self = shift;

    state $context_keywords = P->hash->merge( $self->$orig, $CONTEXT_KEYWORDS );

    return $context_keywords;
};

no Pcore;

sub _sql_limit {
    my $self = shift;
    my $args = $self->_get_limit_args(@_);

    my $sql;

    my $bind = [];

    if ( defined $args->{offset} ) {
        $sql .= q[?, ];

        push $bind, $args->{offset};
    }

    $sql .= q[?];

    push $bind, $args->{limit};

    return \$sql, $bind;
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## ┌──────┬──────────────────────┬────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐
## │ Sev. │ Lines                │ Policy                                                                                                         │
## ╞══════╪══════════════════════╪════════════════════════════════════════════════════════════════════════════════════════════════════════════════╡
## │    3 │ 22                   │ Subroutines::ProhibitUnusedPrivateSubroutines - Private subroutine/method '_sql_limit' declared but not used   │
## └──────┴──────────────────────┴────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::DBD::Builder::MySQL

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut
