=begin comment

Web API Swagger specification

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: 1.0

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package AsposeCellsCloud::CellsApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeCellsCloud::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});


sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'AsposeCellsCloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = AsposeCellsCloud::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# cells_delete_worksheet_columns
#
# Delete worksheet columns.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $column_index The column index. (required)
# @param int $columns The columns. (required)
# @param boolean $update_reference The update reference. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'column_index' => {
        data_type => 'int',
        description => 'The column index.',
        required => '1',
    },
    'columns' => {
        data_type => 'int',
        description => 'The columns.',
        required => '1',
    },
    'update_reference' => {
        data_type => 'boolean',
        description => 'The update reference.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_delete_worksheet_columns' } = { 
    	summary => 'Delete worksheet columns.',
        params => $params,
        returns => 'ColumnsResponse',
        };
}
# @return ColumnsResponse
#
sub cells_delete_worksheet_columns {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_delete_worksheet_columns");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_delete_worksheet_columns");
    }

    # verify the required parameter 'column_index' is set
    unless (exists $args{'column_index'}) {
      croak("Missing the required parameter 'column_index' when calling cells_delete_worksheet_columns");
    }

    # verify the required parameter 'columns' is set
    unless (exists $args{'columns'}) {
      croak("Missing the required parameter 'columns' when calling cells_delete_worksheet_columns");
    }

    # verify the required parameter 'update_reference' is set
    unless (exists $args{'update_reference'}) {
      croak("Missing the required parameter 'update_reference' when calling cells_delete_worksheet_columns");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'columns'}) {
        $query_params->{'columns'} = $self->{api_client}->to_query_value($args{'columns'});
    }

    # query params
    if ( exists $args{'update_reference'}) {
        $query_params->{'updateReference'} = $self->{api_client}->to_query_value($args{'update_reference'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'column_index'}) {
        my $_base_variable = "{" . "columnIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'column_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ColumnsResponse', $response);
    return $_response_object;
}

#
# cells_delete_worksheet_row
#
# Delete worksheet row.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet bame. (required)
# @param int $row_index The row index. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet bame.',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => 'The row index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_delete_worksheet_row' } = { 
    	summary => 'Delete worksheet row.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_delete_worksheet_row {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_delete_worksheet_row");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_delete_worksheet_row");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling cells_delete_worksheet_row");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'row_index'}) {
        my $_base_variable = "{" . "rowIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'row_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_delete_worksheet_rows
#
# Delete several worksheet rows.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet bame. (required)
# @param int $startrow The begin row index to be operated. (required)
# @param int $total_rows Number of rows to be operated. (optional, default to 1)
# @param boolean $update_reference Indicates if update references in other worksheets. (optional, default to true)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet bame.',
        required => '1',
    },
    'startrow' => {
        data_type => 'int',
        description => 'The begin row index to be operated.',
        required => '1',
    },
    'total_rows' => {
        data_type => 'int',
        description => 'Number of rows to be operated.',
        required => '0',
    },
    'update_reference' => {
        data_type => 'boolean',
        description => 'Indicates if update references in other worksheets.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_delete_worksheet_rows' } = { 
    	summary => 'Delete several worksheet rows.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_delete_worksheet_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_delete_worksheet_rows");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_delete_worksheet_rows");
    }

    # verify the required parameter 'startrow' is set
    unless (exists $args{'startrow'}) {
      croak("Missing the required parameter 'startrow' when calling cells_delete_worksheet_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'startrow'}) {
        $query_params->{'startrow'} = $self->{api_client}->to_query_value($args{'startrow'});
    }

    # query params
    if ( exists $args{'total_rows'}) {
        $query_params->{'totalRows'} = $self->{api_client}->to_query_value($args{'total_rows'});
    }

    # query params
    if ( exists $args{'update_reference'}) {
        $query_params->{'updateReference'} = $self->{api_client}->to_query_value($args{'update_reference'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_get_cell_html_string
#
# Read cell data by cell's name.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $cell_name The cell&#39;s  name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => 'The cell&#39;s  name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_get_cell_html_string' } = { 
    	summary => 'Read cell data by cell&#39;s name.',
        params => $params,
        returns => 'object',
        };
}
# @return object
#
sub cells_get_cell_html_string {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_get_cell_html_string");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_get_cell_html_string");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_get_cell_html_string");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/{cellName}/htmlstring';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('object', $response);
    return $_response_object;
}

#
# cells_get_worksheet_cell
#
# Read cell data by cell's name.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $cell_or_method_name The cell&#39;s or method name. (Method name like firstcell, endcell etc.) (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'cell_or_method_name' => {
        data_type => 'string',
        description => 'The cell&#39;s or method name. (Method name like firstcell, endcell etc.)',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_get_worksheet_cell' } = { 
    	summary => 'Read cell data by cell&#39;s name.',
        params => $params,
        returns => 'object',
        };
}
# @return object
#
sub cells_get_worksheet_cell {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_get_worksheet_cell");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_get_worksheet_cell");
    }

    # verify the required parameter 'cell_or_method_name' is set
    unless (exists $args{'cell_or_method_name'}) {
      croak("Missing the required parameter 'cell_or_method_name' when calling cells_get_worksheet_cell");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/{cellOrMethodName}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_or_method_name'}) {
        my $_base_variable = "{" . "cellOrMethodName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_or_method_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('object', $response);
    return $_response_object;
}

#
# cells_get_worksheet_cell_style
#
# Read cell's style info.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $cell_name Cell&#39;s name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => 'Cell&#39;s name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_get_worksheet_cell_style' } = { 
    	summary => 'Read cell&#39;s style info.',
        params => $params,
        returns => 'StyleResponse',
        };
}
# @return StyleResponse
#
sub cells_get_worksheet_cell_style {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_get_worksheet_cell_style");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_get_worksheet_cell_style");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_get_worksheet_cell_style");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/{cellName}/style';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('StyleResponse', $response);
    return $_response_object;
}

#
# cells_get_worksheet_cells
#
# Get cells info.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $offest Begginig offset. (optional, default to 0)
# @param int $count Maximum amount of cells in the response. (optional, default to 0)
# @param string $folder Document&#39;s folder name. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'offest' => {
        data_type => 'int',
        description => 'Begginig offset.',
        required => '0',
    },
    'count' => {
        data_type => 'int',
        description => 'Maximum amount of cells in the response.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder name.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_get_worksheet_cells' } = { 
    	summary => 'Get cells info.',
        params => $params,
        returns => 'CellsResponse',
        };
}
# @return CellsResponse
#
sub cells_get_worksheet_cells {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_get_worksheet_cells");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_get_worksheet_cells");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'offest'}) {
        $query_params->{'offest'} = $self->{api_client}->to_query_value($args{'offest'});
    }

    # query params
    if ( exists $args{'count'}) {
        $query_params->{'count'} = $self->{api_client}->to_query_value($args{'count'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsResponse', $response);
    return $_response_object;
}

#
# cells_get_worksheet_column
#
# Read worksheet column data by column's index.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $column_index The column index. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'column_index' => {
        data_type => 'int',
        description => 'The column index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_get_worksheet_column' } = { 
    	summary => 'Read worksheet column data by column&#39;s index.',
        params => $params,
        returns => 'ColumnResponse',
        };
}
# @return ColumnResponse
#
sub cells_get_worksheet_column {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_get_worksheet_column");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_get_worksheet_column");
    }

    # verify the required parameter 'column_index' is set
    unless (exists $args{'column_index'}) {
      croak("Missing the required parameter 'column_index' when calling cells_get_worksheet_column");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'column_index'}) {
        my $_base_variable = "{" . "columnIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'column_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ColumnResponse', $response);
    return $_response_object;
}

#
# cells_get_worksheet_columns
#
# Read worksheet columns info.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder The workdook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workdook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_get_worksheet_columns' } = { 
    	summary => 'Read worksheet columns info.',
        params => $params,
        returns => 'ColumnsResponse',
        };
}
# @return ColumnsResponse
#
sub cells_get_worksheet_columns {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_get_worksheet_columns");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_get_worksheet_columns");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ColumnsResponse', $response);
    return $_response_object;
}

#
# cells_get_worksheet_row
#
# Read worksheet row data by row's index.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $row_index The row index. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => 'The row index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_get_worksheet_row' } = { 
    	summary => 'Read worksheet row data by row&#39;s index.',
        params => $params,
        returns => 'RowResponse',
        };
}
# @return RowResponse
#
sub cells_get_worksheet_row {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_get_worksheet_row");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_get_worksheet_row");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling cells_get_worksheet_row");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'row_index'}) {
        my $_base_variable = "{" . "rowIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'row_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('RowResponse', $response);
    return $_response_object;
}

#
# cells_get_worksheet_rows
#
# Read worksheet rows info.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder The workdook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workdook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_get_worksheet_rows' } = { 
    	summary => 'Read worksheet rows info.',
        params => $params,
        returns => 'RowsResponse',
        };
}
# @return RowsResponse
#
sub cells_get_worksheet_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_get_worksheet_rows");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_get_worksheet_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('RowsResponse', $response);
    return $_response_object;
}

#
# cells_post_cell_calculate
#
# Cell calculate formula
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $cell_name  (required)
# @param CalculationOptions $options  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'options' => {
        data_type => 'CalculationOptions',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_cell_calculate' } = { 
    	summary => 'Cell calculate formula',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_cell_calculate {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_cell_calculate");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_cell_calculate");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_post_cell_calculate");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/{cellName}/calculate';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_cell_characters
#
# Set cell characters 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $cell_name  (required)
# @param ARRAY[FontSetting] $options  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'options' => {
        data_type => 'ARRAY[FontSetting]',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_cell_characters' } = { 
    	summary => 'Set cell characters ',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_cell_characters {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_cell_characters");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_cell_characters");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_post_cell_characters");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/{cellName}/characters';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_clear_contents
#
# Clear cells contents.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $range The range. (optional)
# @param int $start_row The start row. (optional)
# @param int $start_column The start column. (optional)
# @param int $end_row The end row. (optional)
# @param int $end_column The end column. (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => 'The range.',
        required => '0',
    },
    'start_row' => {
        data_type => 'int',
        description => 'The start row.',
        required => '0',
    },
    'start_column' => {
        data_type => 'int',
        description => 'The start column.',
        required => '0',
    },
    'end_row' => {
        data_type => 'int',
        description => 'The end row.',
        required => '0',
    },
    'end_column' => {
        data_type => 'int',
        description => 'The end column.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_clear_contents' } = { 
    	summary => 'Clear cells contents.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_clear_contents {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_clear_contents");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_clear_contents");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/clearcontents';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'start_row'}) {
        $query_params->{'startRow'} = $self->{api_client}->to_query_value($args{'start_row'});
    }

    # query params
    if ( exists $args{'start_column'}) {
        $query_params->{'startColumn'} = $self->{api_client}->to_query_value($args{'start_column'});
    }

    # query params
    if ( exists $args{'end_row'}) {
        $query_params->{'endRow'} = $self->{api_client}->to_query_value($args{'end_row'});
    }

    # query params
    if ( exists $args{'end_column'}) {
        $query_params->{'endColumn'} = $self->{api_client}->to_query_value($args{'end_column'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_clear_formats
#
# Clear cells contents.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $range The range. (optional)
# @param int $start_row The start row. (optional)
# @param int $start_column The start column. (optional)
# @param int $end_row The end row. (optional)
# @param int $end_column The end column. (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => 'The range.',
        required => '0',
    },
    'start_row' => {
        data_type => 'int',
        description => 'The start row.',
        required => '0',
    },
    'start_column' => {
        data_type => 'int',
        description => 'The start column.',
        required => '0',
    },
    'end_row' => {
        data_type => 'int',
        description => 'The end row.',
        required => '0',
    },
    'end_column' => {
        data_type => 'int',
        description => 'The end column.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_clear_formats' } = { 
    	summary => 'Clear cells contents.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_clear_formats {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_clear_formats");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_clear_formats");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/clearformats';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'start_row'}) {
        $query_params->{'startRow'} = $self->{api_client}->to_query_value($args{'start_row'});
    }

    # query params
    if ( exists $args{'start_column'}) {
        $query_params->{'startColumn'} = $self->{api_client}->to_query_value($args{'start_column'});
    }

    # query params
    if ( exists $args{'end_row'}) {
        $query_params->{'endRow'} = $self->{api_client}->to_query_value($args{'end_row'});
    }

    # query params
    if ( exists $args{'end_column'}) {
        $query_params->{'endColumn'} = $self->{api_client}->to_query_value($args{'end_column'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_column_style
#
# Set column style
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $column_index The column index. (required)
# @param Style $style Style dto (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'column_index' => {
        data_type => 'int',
        description => 'The column index.',
        required => '1',
    },
    'style' => {
        data_type => 'Style',
        description => 'Style dto',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_column_style' } = { 
    	summary => 'Set column style',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_column_style {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_column_style");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_column_style");
    }

    # verify the required parameter 'column_index' is set
    unless (exists $args{'column_index'}) {
      croak("Missing the required parameter 'column_index' when calling cells_post_column_style");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex}/style';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'column_index'}) {
        my $_base_variable = "{" . "columnIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'column_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'style'}) {
        $_body_data = $args{'style'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_copy_cell_into_cell
#
# Copy cell into cell
# 
# @param string $name Workbook name. (required)
# @param string $dest_cell_name Destination cell name (required)
# @param string $sheet_name Destination worksheet name. (required)
# @param string $worksheet Source worksheet name. (required)
# @param string $cellname Source cell name (optional)
# @param int $row Source row (optional)
# @param int $column Source column (optional)
# @param string $folder Folder name (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'dest_cell_name' => {
        data_type => 'string',
        description => 'Destination cell name',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Destination worksheet name.',
        required => '1',
    },
    'worksheet' => {
        data_type => 'string',
        description => 'Source worksheet name.',
        required => '1',
    },
    'cellname' => {
        data_type => 'string',
        description => 'Source cell name',
        required => '0',
    },
    'row' => {
        data_type => 'int',
        description => 'Source row',
        required => '0',
    },
    'column' => {
        data_type => 'int',
        description => 'Source column',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Folder name',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_copy_cell_into_cell' } = { 
    	summary => 'Copy cell into cell',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_copy_cell_into_cell {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_copy_cell_into_cell");
    }

    # verify the required parameter 'dest_cell_name' is set
    unless (exists $args{'dest_cell_name'}) {
      croak("Missing the required parameter 'dest_cell_name' when calling cells_post_copy_cell_into_cell");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_copy_cell_into_cell");
    }

    # verify the required parameter 'worksheet' is set
    unless (exists $args{'worksheet'}) {
      croak("Missing the required parameter 'worksheet' when calling cells_post_copy_cell_into_cell");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/{destCellName}/copy';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'worksheet'}) {
        $query_params->{'worksheet'} = $self->{api_client}->to_query_value($args{'worksheet'});
    }

    # query params
    if ( exists $args{'cellname'}) {
        $query_params->{'cellname'} = $self->{api_client}->to_query_value($args{'cellname'});
    }

    # query params
    if ( exists $args{'row'}) {
        $query_params->{'row'} = $self->{api_client}->to_query_value($args{'row'});
    }

    # query params
    if ( exists $args{'column'}) {
        $query_params->{'column'} = $self->{api_client}->to_query_value($args{'column'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'dest_cell_name'}) {
        my $_base_variable = "{" . "destCellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'dest_cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_copy_worksheet_columns
#
# Copy worksheet columns.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $source_column_index Source column index (required)
# @param int $destination_column_index Destination column index (required)
# @param int $column_number The copied column number (required)
# @param string $worksheet The Worksheet (optional, default to )
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'source_column_index' => {
        data_type => 'int',
        description => 'Source column index',
        required => '1',
    },
    'destination_column_index' => {
        data_type => 'int',
        description => 'Destination column index',
        required => '1',
    },
    'column_number' => {
        data_type => 'int',
        description => 'The copied column number',
        required => '1',
    },
    'worksheet' => {
        data_type => 'string',
        description => 'The Worksheet',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_copy_worksheet_columns' } = { 
    	summary => 'Copy worksheet columns.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_copy_worksheet_columns {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_copy_worksheet_columns");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_copy_worksheet_columns");
    }

    # verify the required parameter 'source_column_index' is set
    unless (exists $args{'source_column_index'}) {
      croak("Missing the required parameter 'source_column_index' when calling cells_post_copy_worksheet_columns");
    }

    # verify the required parameter 'destination_column_index' is set
    unless (exists $args{'destination_column_index'}) {
      croak("Missing the required parameter 'destination_column_index' when calling cells_post_copy_worksheet_columns");
    }

    # verify the required parameter 'column_number' is set
    unless (exists $args{'column_number'}) {
      croak("Missing the required parameter 'column_number' when calling cells_post_copy_worksheet_columns");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/copy';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'source_column_index'}) {
        $query_params->{'sourceColumnIndex'} = $self->{api_client}->to_query_value($args{'source_column_index'});
    }

    # query params
    if ( exists $args{'destination_column_index'}) {
        $query_params->{'destinationColumnIndex'} = $self->{api_client}->to_query_value($args{'destination_column_index'});
    }

    # query params
    if ( exists $args{'column_number'}) {
        $query_params->{'columnNumber'} = $self->{api_client}->to_query_value($args{'column_number'});
    }

    # query params
    if ( exists $args{'worksheet'}) {
        $query_params->{'worksheet'} = $self->{api_client}->to_query_value($args{'worksheet'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_copy_worksheet_rows
#
# Copy worksheet rows.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $source_row_index Source row index (required)
# @param int $destination_row_index Destination row index (required)
# @param int $row_number The copied row number (required)
# @param string $worksheet worksheet (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'source_row_index' => {
        data_type => 'int',
        description => 'Source row index',
        required => '1',
    },
    'destination_row_index' => {
        data_type => 'int',
        description => 'Destination row index',
        required => '1',
    },
    'row_number' => {
        data_type => 'int',
        description => 'The copied row number',
        required => '1',
    },
    'worksheet' => {
        data_type => 'string',
        description => 'worksheet',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_copy_worksheet_rows' } = { 
    	summary => 'Copy worksheet rows.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_copy_worksheet_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_copy_worksheet_rows");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_copy_worksheet_rows");
    }

    # verify the required parameter 'source_row_index' is set
    unless (exists $args{'source_row_index'}) {
      croak("Missing the required parameter 'source_row_index' when calling cells_post_copy_worksheet_rows");
    }

    # verify the required parameter 'destination_row_index' is set
    unless (exists $args{'destination_row_index'}) {
      croak("Missing the required parameter 'destination_row_index' when calling cells_post_copy_worksheet_rows");
    }

    # verify the required parameter 'row_number' is set
    unless (exists $args{'row_number'}) {
      croak("Missing the required parameter 'row_number' when calling cells_post_copy_worksheet_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/copy';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'source_row_index'}) {
        $query_params->{'sourceRowIndex'} = $self->{api_client}->to_query_value($args{'source_row_index'});
    }

    # query params
    if ( exists $args{'destination_row_index'}) {
        $query_params->{'destinationRowIndex'} = $self->{api_client}->to_query_value($args{'destination_row_index'});
    }

    # query params
    if ( exists $args{'row_number'}) {
        $query_params->{'rowNumber'} = $self->{api_client}->to_query_value($args{'row_number'});
    }

    # query params
    if ( exists $args{'worksheet'}) {
        $query_params->{'worksheet'} = $self->{api_client}->to_query_value($args{'worksheet'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_group_worksheet_columns
#
# Group worksheet columns.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $first_index The first column index to be operated. (required)
# @param int $last_index The last column index to be operated. (required)
# @param boolean $hide columns visible state (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'first_index' => {
        data_type => 'int',
        description => 'The first column index to be operated.',
        required => '1',
    },
    'last_index' => {
        data_type => 'int',
        description => 'The last column index to be operated.',
        required => '1',
    },
    'hide' => {
        data_type => 'boolean',
        description => 'columns visible state',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_group_worksheet_columns' } = { 
    	summary => 'Group worksheet columns.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_group_worksheet_columns {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_group_worksheet_columns");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_group_worksheet_columns");
    }

    # verify the required parameter 'first_index' is set
    unless (exists $args{'first_index'}) {
      croak("Missing the required parameter 'first_index' when calling cells_post_group_worksheet_columns");
    }

    # verify the required parameter 'last_index' is set
    unless (exists $args{'last_index'}) {
      croak("Missing the required parameter 'last_index' when calling cells_post_group_worksheet_columns");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/group';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'first_index'}) {
        $query_params->{'firstIndex'} = $self->{api_client}->to_query_value($args{'first_index'});
    }

    # query params
    if ( exists $args{'last_index'}) {
        $query_params->{'lastIndex'} = $self->{api_client}->to_query_value($args{'last_index'});
    }

    # query params
    if ( exists $args{'hide'}) {
        $query_params->{'hide'} = $self->{api_client}->to_query_value($args{'hide'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_group_worksheet_rows
#
# Group worksheet rows.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $first_index The first row index to be operated. (required)
# @param int $last_index The last row index to be operated. (required)
# @param boolean $hide rows visible state (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'first_index' => {
        data_type => 'int',
        description => 'The first row index to be operated.',
        required => '1',
    },
    'last_index' => {
        data_type => 'int',
        description => 'The last row index to be operated.',
        required => '1',
    },
    'hide' => {
        data_type => 'boolean',
        description => 'rows visible state',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_group_worksheet_rows' } = { 
    	summary => 'Group worksheet rows.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_group_worksheet_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_group_worksheet_rows");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_group_worksheet_rows");
    }

    # verify the required parameter 'first_index' is set
    unless (exists $args{'first_index'}) {
      croak("Missing the required parameter 'first_index' when calling cells_post_group_worksheet_rows");
    }

    # verify the required parameter 'last_index' is set
    unless (exists $args{'last_index'}) {
      croak("Missing the required parameter 'last_index' when calling cells_post_group_worksheet_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/group';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'first_index'}) {
        $query_params->{'firstIndex'} = $self->{api_client}->to_query_value($args{'first_index'});
    }

    # query params
    if ( exists $args{'last_index'}) {
        $query_params->{'lastIndex'} = $self->{api_client}->to_query_value($args{'last_index'});
    }

    # query params
    if ( exists $args{'hide'}) {
        $query_params->{'hide'} = $self->{api_client}->to_query_value($args{'hide'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_hide_worksheet_columns
#
# Hide worksheet columns.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $start_column The begin column index to be operated. (required)
# @param int $total_columns Number of columns to be operated. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'start_column' => {
        data_type => 'int',
        description => 'The begin column index to be operated.',
        required => '1',
    },
    'total_columns' => {
        data_type => 'int',
        description => 'Number of columns to be operated.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_hide_worksheet_columns' } = { 
    	summary => 'Hide worksheet columns.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_hide_worksheet_columns {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_hide_worksheet_columns");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_hide_worksheet_columns");
    }

    # verify the required parameter 'start_column' is set
    unless (exists $args{'start_column'}) {
      croak("Missing the required parameter 'start_column' when calling cells_post_hide_worksheet_columns");
    }

    # verify the required parameter 'total_columns' is set
    unless (exists $args{'total_columns'}) {
      croak("Missing the required parameter 'total_columns' when calling cells_post_hide_worksheet_columns");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/hide';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'start_column'}) {
        $query_params->{'startColumn'} = $self->{api_client}->to_query_value($args{'start_column'});
    }

    # query params
    if ( exists $args{'total_columns'}) {
        $query_params->{'totalColumns'} = $self->{api_client}->to_query_value($args{'total_columns'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_hide_worksheet_rows
#
# Hide worksheet rows.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $startrow The begin row index to be operated. (required)
# @param int $total_rows Number of rows to be operated. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'startrow' => {
        data_type => 'int',
        description => 'The begin row index to be operated.',
        required => '1',
    },
    'total_rows' => {
        data_type => 'int',
        description => 'Number of rows to be operated.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_hide_worksheet_rows' } = { 
    	summary => 'Hide worksheet rows.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_hide_worksheet_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_hide_worksheet_rows");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_hide_worksheet_rows");
    }

    # verify the required parameter 'startrow' is set
    unless (exists $args{'startrow'}) {
      croak("Missing the required parameter 'startrow' when calling cells_post_hide_worksheet_rows");
    }

    # verify the required parameter 'total_rows' is set
    unless (exists $args{'total_rows'}) {
      croak("Missing the required parameter 'total_rows' when calling cells_post_hide_worksheet_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/hide';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'startrow'}) {
        $query_params->{'startrow'} = $self->{api_client}->to_query_value($args{'startrow'});
    }

    # query params
    if ( exists $args{'total_rows'}) {
        $query_params->{'totalRows'} = $self->{api_client}->to_query_value($args{'total_rows'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_row_style
#
# Set row style.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $row_index The row index. (required)
# @param Style $style Style dto (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => 'The row index.',
        required => '1',
    },
    'style' => {
        data_type => 'Style',
        description => 'Style dto',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_row_style' } = { 
    	summary => 'Set row style.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_row_style {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_row_style");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_row_style");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling cells_post_row_style");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex}/style';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'row_index'}) {
        my $_base_variable = "{" . "rowIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'row_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'style'}) {
        $_body_data = $args{'style'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_set_cell_html_string
#
# Set htmlstring value into cell
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $cell_name The cell name. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => 'The cell name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_set_cell_html_string' } = { 
    	summary => 'Set htmlstring value into cell',
        params => $params,
        returns => 'CellResponse',
        };
}
# @return CellResponse
#
sub cells_post_set_cell_html_string {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_set_cell_html_string");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_set_cell_html_string");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_post_set_cell_html_string");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/{cellName}/htmlstring';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellResponse', $response);
    return $_response_object;
}

#
# cells_post_set_cell_range_value
#
# Set cell range value 
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $cellarea Cell area (like \&quot;A1:C2\&quot;) (required)
# @param string $value Range value (required)
# @param string $type Value data type (like \&quot;int\&quot;) (required)
# @param string $folder Folder name (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'cellarea' => {
        data_type => 'string',
        description => 'Cell area (like \&quot;A1:C2\&quot;)',
        required => '1',
    },
    'value' => {
        data_type => 'string',
        description => 'Range value',
        required => '1',
    },
    'type' => {
        data_type => 'string',
        description => 'Value data type (like \&quot;int\&quot;)',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Folder name',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_set_cell_range_value' } = { 
    	summary => 'Set cell range value ',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_set_cell_range_value {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_set_cell_range_value");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_set_cell_range_value");
    }

    # verify the required parameter 'cellarea' is set
    unless (exists $args{'cellarea'}) {
      croak("Missing the required parameter 'cellarea' when calling cells_post_set_cell_range_value");
    }

    # verify the required parameter 'value' is set
    unless (exists $args{'value'}) {
      croak("Missing the required parameter 'value' when calling cells_post_set_cell_range_value");
    }

    # verify the required parameter 'type' is set
    unless (exists $args{'type'}) {
      croak("Missing the required parameter 'type' when calling cells_post_set_cell_range_value");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'cellarea'}) {
        $query_params->{'cellarea'} = $self->{api_client}->to_query_value($args{'cellarea'});
    }

    # query params
    if ( exists $args{'value'}) {
        $query_params->{'value'} = $self->{api_client}->to_query_value($args{'value'});
    }

    # query params
    if ( exists $args{'type'}) {
        $query_params->{'type'} = $self->{api_client}->to_query_value($args{'type'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_set_worksheet_column_width
#
# Set worksheet column width.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $column_index The column index. (required)
# @param double $width The width. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'column_index' => {
        data_type => 'int',
        description => 'The column index.',
        required => '1',
    },
    'width' => {
        data_type => 'double',
        description => 'The width.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_set_worksheet_column_width' } = { 
    	summary => 'Set worksheet column width.',
        params => $params,
        returns => 'ColumnResponse',
        };
}
# @return ColumnResponse
#
sub cells_post_set_worksheet_column_width {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_set_worksheet_column_width");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_set_worksheet_column_width");
    }

    # verify the required parameter 'column_index' is set
    unless (exists $args{'column_index'}) {
      croak("Missing the required parameter 'column_index' when calling cells_post_set_worksheet_column_width");
    }

    # verify the required parameter 'width' is set
    unless (exists $args{'width'}) {
      croak("Missing the required parameter 'width' when calling cells_post_set_worksheet_column_width");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'column_index'}) {
        my $_base_variable = "{" . "columnIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'column_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ColumnResponse', $response);
    return $_response_object;
}

#
# cells_post_ungroup_worksheet_columns
#
# Ungroup worksheet columns.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $first_index The first column index to be operated. (required)
# @param int $last_index The last column index to be operated. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'first_index' => {
        data_type => 'int',
        description => 'The first column index to be operated.',
        required => '1',
    },
    'last_index' => {
        data_type => 'int',
        description => 'The last column index to be operated.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_ungroup_worksheet_columns' } = { 
    	summary => 'Ungroup worksheet columns.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_ungroup_worksheet_columns {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_ungroup_worksheet_columns");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_ungroup_worksheet_columns");
    }

    # verify the required parameter 'first_index' is set
    unless (exists $args{'first_index'}) {
      croak("Missing the required parameter 'first_index' when calling cells_post_ungroup_worksheet_columns");
    }

    # verify the required parameter 'last_index' is set
    unless (exists $args{'last_index'}) {
      croak("Missing the required parameter 'last_index' when calling cells_post_ungroup_worksheet_columns");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/ungroup';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'first_index'}) {
        $query_params->{'firstIndex'} = $self->{api_client}->to_query_value($args{'first_index'});
    }

    # query params
    if ( exists $args{'last_index'}) {
        $query_params->{'lastIndex'} = $self->{api_client}->to_query_value($args{'last_index'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_ungroup_worksheet_rows
#
# Ungroup worksheet rows.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $first_index The first row index to be operated. (required)
# @param int $last_index The last row index to be operated. (required)
# @param boolean $is_all Is all row to be operated (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'first_index' => {
        data_type => 'int',
        description => 'The first row index to be operated.',
        required => '1',
    },
    'last_index' => {
        data_type => 'int',
        description => 'The last row index to be operated.',
        required => '1',
    },
    'is_all' => {
        data_type => 'boolean',
        description => 'Is all row to be operated',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_ungroup_worksheet_rows' } = { 
    	summary => 'Ungroup worksheet rows.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_ungroup_worksheet_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_ungroup_worksheet_rows");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_ungroup_worksheet_rows");
    }

    # verify the required parameter 'first_index' is set
    unless (exists $args{'first_index'}) {
      croak("Missing the required parameter 'first_index' when calling cells_post_ungroup_worksheet_rows");
    }

    # verify the required parameter 'last_index' is set
    unless (exists $args{'last_index'}) {
      croak("Missing the required parameter 'last_index' when calling cells_post_ungroup_worksheet_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/ungroup';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'first_index'}) {
        $query_params->{'firstIndex'} = $self->{api_client}->to_query_value($args{'first_index'});
    }

    # query params
    if ( exists $args{'last_index'}) {
        $query_params->{'lastIndex'} = $self->{api_client}->to_query_value($args{'last_index'});
    }

    # query params
    if ( exists $args{'is_all'}) {
        $query_params->{'isAll'} = $self->{api_client}->to_query_value($args{'is_all'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_unhide_worksheet_columns
#
# Unhide worksheet columns.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $startcolumn The begin column index to be operated. (required)
# @param int $total_columns Number of columns to be operated. (required)
# @param double $width The new column width. (optional, default to 50.0)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'startcolumn' => {
        data_type => 'int',
        description => 'The begin column index to be operated.',
        required => '1',
    },
    'total_columns' => {
        data_type => 'int',
        description => 'Number of columns to be operated.',
        required => '1',
    },
    'width' => {
        data_type => 'double',
        description => 'The new column width.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_unhide_worksheet_columns' } = { 
    	summary => 'Unhide worksheet columns.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_unhide_worksheet_columns {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_unhide_worksheet_columns");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_unhide_worksheet_columns");
    }

    # verify the required parameter 'startcolumn' is set
    unless (exists $args{'startcolumn'}) {
      croak("Missing the required parameter 'startcolumn' when calling cells_post_unhide_worksheet_columns");
    }

    # verify the required parameter 'total_columns' is set
    unless (exists $args{'total_columns'}) {
      croak("Missing the required parameter 'total_columns' when calling cells_post_unhide_worksheet_columns");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/unhide';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'startcolumn'}) {
        $query_params->{'startcolumn'} = $self->{api_client}->to_query_value($args{'startcolumn'});
    }

    # query params
    if ( exists $args{'total_columns'}) {
        $query_params->{'totalColumns'} = $self->{api_client}->to_query_value($args{'total_columns'});
    }

    # query params
    if ( exists $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_unhide_worksheet_rows
#
# Unhide worksheet rows.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $startrow The begin row index to be operated. (required)
# @param int $total_rows Number of rows to be operated. (required)
# @param double $height The new row height. (optional, default to 15.0)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'startrow' => {
        data_type => 'int',
        description => 'The begin row index to be operated.',
        required => '1',
    },
    'total_rows' => {
        data_type => 'int',
        description => 'Number of rows to be operated.',
        required => '1',
    },
    'height' => {
        data_type => 'double',
        description => 'The new row height.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_unhide_worksheet_rows' } = { 
    	summary => 'Unhide worksheet rows.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_unhide_worksheet_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_unhide_worksheet_rows");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_unhide_worksheet_rows");
    }

    # verify the required parameter 'startrow' is set
    unless (exists $args{'startrow'}) {
      croak("Missing the required parameter 'startrow' when calling cells_post_unhide_worksheet_rows");
    }

    # verify the required parameter 'total_rows' is set
    unless (exists $args{'total_rows'}) {
      croak("Missing the required parameter 'total_rows' when calling cells_post_unhide_worksheet_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/unhide';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'startrow'}) {
        $query_params->{'startrow'} = $self->{api_client}->to_query_value($args{'startrow'});
    }

    # query params
    if ( exists $args{'total_rows'}) {
        $query_params->{'totalRows'} = $self->{api_client}->to_query_value($args{'total_rows'});
    }

    # query params
    if ( exists $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_update_worksheet_cell_style
#
# Update cell's style.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $cell_name The cell name. (required)
# @param Style $style with update style settings. (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => 'The cell name.',
        required => '1',
    },
    'style' => {
        data_type => 'Style',
        description => 'with update style settings.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_update_worksheet_cell_style' } = { 
    	summary => 'Update cell&#39;s style.',
        params => $params,
        returns => 'StyleResponse',
        };
}
# @return StyleResponse
#
sub cells_post_update_worksheet_cell_style {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_update_worksheet_cell_style");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_update_worksheet_cell_style");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_post_update_worksheet_cell_style");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/{cellName}/style';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'style'}) {
        $_body_data = $args{'style'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('StyleResponse', $response);
    return $_response_object;
}

#
# cells_post_update_worksheet_range_style
#
# Update cell's range style.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $range The range. (required)
# @param Style $style with update style settings. (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => 'The range.',
        required => '1',
    },
    'style' => {
        data_type => 'Style',
        description => 'with update style settings.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_update_worksheet_range_style' } = { 
    	summary => 'Update cell&#39;s range style.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_update_worksheet_range_style {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_update_worksheet_range_style");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_update_worksheet_range_style");
    }

    # verify the required parameter 'range' is set
    unless (exists $args{'range'}) {
      croak("Missing the required parameter 'range' when calling cells_post_update_worksheet_range_style");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/style';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'style'}) {
        $_body_data = $args{'style'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_update_worksheet_row
#
# Update worksheet row.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $row_index The row index. (required)
# @param double $height The new row height. (optional, default to 0.0)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => 'The row index.',
        required => '1',
    },
    'height' => {
        data_type => 'double',
        description => 'The new row height.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_update_worksheet_row' } = { 
    	summary => 'Update worksheet row.',
        params => $params,
        returns => 'RowResponse',
        };
}
# @return RowResponse
#
sub cells_post_update_worksheet_row {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_update_worksheet_row");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_update_worksheet_row");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling cells_post_update_worksheet_row");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'row_index'}) {
        my $_base_variable = "{" . "rowIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'row_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('RowResponse', $response);
    return $_response_object;
}

#
# cells_post_worksheet_cell_set_value
#
# Set cell value.
# 
# @param string $name The document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $cell_name The cell name. (required)
# @param string $value The cell value. (optional)
# @param string $type The value type. (optional)
# @param string $formula Formula for cell (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => 'The cell name.',
        required => '1',
    },
    'value' => {
        data_type => 'string',
        description => 'The cell value.',
        required => '0',
    },
    'type' => {
        data_type => 'string',
        description => 'The value type.',
        required => '0',
    },
    'formula' => {
        data_type => 'string',
        description => 'Formula for cell',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_worksheet_cell_set_value' } = { 
    	summary => 'Set cell value.',
        params => $params,
        returns => 'CellResponse',
        };
}
# @return CellResponse
#
sub cells_post_worksheet_cell_set_value {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_worksheet_cell_set_value");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_worksheet_cell_set_value");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_post_worksheet_cell_set_value");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/{cellName}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'value'}) {
        $query_params->{'value'} = $self->{api_client}->to_query_value($args{'value'});
    }

    # query params
    if ( exists $args{'type'}) {
        $query_params->{'type'} = $self->{api_client}->to_query_value($args{'type'});
    }

    # query params
    if ( exists $args{'formula'}) {
        $query_params->{'formula'} = $self->{api_client}->to_query_value($args{'formula'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellResponse', $response);
    return $_response_object;
}

#
# cells_post_worksheet_merge
#
# Merge cells.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $start_row The start row. (required)
# @param int $start_column The start column. (required)
# @param int $total_rows The total rows (required)
# @param int $total_columns The total columns. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'start_row' => {
        data_type => 'int',
        description => 'The start row.',
        required => '1',
    },
    'start_column' => {
        data_type => 'int',
        description => 'The start column.',
        required => '1',
    },
    'total_rows' => {
        data_type => 'int',
        description => 'The total rows',
        required => '1',
    },
    'total_columns' => {
        data_type => 'int',
        description => 'The total columns.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_worksheet_merge' } = { 
    	summary => 'Merge cells.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_worksheet_merge {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_worksheet_merge");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_worksheet_merge");
    }

    # verify the required parameter 'start_row' is set
    unless (exists $args{'start_row'}) {
      croak("Missing the required parameter 'start_row' when calling cells_post_worksheet_merge");
    }

    # verify the required parameter 'start_column' is set
    unless (exists $args{'start_column'}) {
      croak("Missing the required parameter 'start_column' when calling cells_post_worksheet_merge");
    }

    # verify the required parameter 'total_rows' is set
    unless (exists $args{'total_rows'}) {
      croak("Missing the required parameter 'total_rows' when calling cells_post_worksheet_merge");
    }

    # verify the required parameter 'total_columns' is set
    unless (exists $args{'total_columns'}) {
      croak("Missing the required parameter 'total_columns' when calling cells_post_worksheet_merge");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/merge';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'start_row'}) {
        $query_params->{'startRow'} = $self->{api_client}->to_query_value($args{'start_row'});
    }

    # query params
    if ( exists $args{'start_column'}) {
        $query_params->{'startColumn'} = $self->{api_client}->to_query_value($args{'start_column'});
    }

    # query params
    if ( exists $args{'total_rows'}) {
        $query_params->{'totalRows'} = $self->{api_client}->to_query_value($args{'total_rows'});
    }

    # query params
    if ( exists $args{'total_columns'}) {
        $query_params->{'totalColumns'} = $self->{api_client}->to_query_value($args{'total_columns'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_post_worksheet_unmerge
#
# Unmerge cells.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $start_row The start row. (required)
# @param int $start_column The start column. (required)
# @param int $total_rows The total rows (required)
# @param int $total_columns The total columns. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'start_row' => {
        data_type => 'int',
        description => 'The start row.',
        required => '1',
    },
    'start_column' => {
        data_type => 'int',
        description => 'The start column.',
        required => '1',
    },
    'total_rows' => {
        data_type => 'int',
        description => 'The total rows',
        required => '1',
    },
    'total_columns' => {
        data_type => 'int',
        description => 'The total columns.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_worksheet_unmerge' } = { 
    	summary => 'Unmerge cells.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_post_worksheet_unmerge {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_worksheet_unmerge");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_worksheet_unmerge");
    }

    # verify the required parameter 'start_row' is set
    unless (exists $args{'start_row'}) {
      croak("Missing the required parameter 'start_row' when calling cells_post_worksheet_unmerge");
    }

    # verify the required parameter 'start_column' is set
    unless (exists $args{'start_column'}) {
      croak("Missing the required parameter 'start_column' when calling cells_post_worksheet_unmerge");
    }

    # verify the required parameter 'total_rows' is set
    unless (exists $args{'total_rows'}) {
      croak("Missing the required parameter 'total_rows' when calling cells_post_worksheet_unmerge");
    }

    # verify the required parameter 'total_columns' is set
    unless (exists $args{'total_columns'}) {
      croak("Missing the required parameter 'total_columns' when calling cells_post_worksheet_unmerge");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/unmerge';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'start_row'}) {
        $query_params->{'startRow'} = $self->{api_client}->to_query_value($args{'start_row'});
    }

    # query params
    if ( exists $args{'start_column'}) {
        $query_params->{'startColumn'} = $self->{api_client}->to_query_value($args{'start_column'});
    }

    # query params
    if ( exists $args{'total_rows'}) {
        $query_params->{'totalRows'} = $self->{api_client}->to_query_value($args{'total_rows'});
    }

    # query params
    if ( exists $args{'total_columns'}) {
        $query_params->{'totalColumns'} = $self->{api_client}->to_query_value($args{'total_columns'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_put_insert_worksheet_columns
#
# Insert worksheet columns.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $column_index The column index. (required)
# @param int $columns The columns. (required)
# @param boolean $update_reference The update reference. (optional, default to true)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'column_index' => {
        data_type => 'int',
        description => 'The column index.',
        required => '1',
    },
    'columns' => {
        data_type => 'int',
        description => 'The columns.',
        required => '1',
    },
    'update_reference' => {
        data_type => 'boolean',
        description => 'The update reference.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_put_insert_worksheet_columns' } = { 
    	summary => 'Insert worksheet columns.',
        params => $params,
        returns => 'ColumnsResponse',
        };
}
# @return ColumnsResponse
#
sub cells_put_insert_worksheet_columns {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_put_insert_worksheet_columns");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_put_insert_worksheet_columns");
    }

    # verify the required parameter 'column_index' is set
    unless (exists $args{'column_index'}) {
      croak("Missing the required parameter 'column_index' when calling cells_put_insert_worksheet_columns");
    }

    # verify the required parameter 'columns' is set
    unless (exists $args{'columns'}) {
      croak("Missing the required parameter 'columns' when calling cells_put_insert_worksheet_columns");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'columns'}) {
        $query_params->{'columns'} = $self->{api_client}->to_query_value($args{'columns'});
    }

    # query params
    if ( exists $args{'update_reference'}) {
        $query_params->{'updateReference'} = $self->{api_client}->to_query_value($args{'update_reference'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'column_index'}) {
        my $_base_variable = "{" . "columnIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'column_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ColumnsResponse', $response);
    return $_response_object;
}

#
# cells_put_insert_worksheet_row
#
# Insert new worksheet row.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $row_index The new row index. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => 'The new row index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_put_insert_worksheet_row' } = { 
    	summary => 'Insert new worksheet row.',
        params => $params,
        returns => 'RowResponse',
        };
}
# @return RowResponse
#
sub cells_put_insert_worksheet_row {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_put_insert_worksheet_row");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_put_insert_worksheet_row");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling cells_put_insert_worksheet_row");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'row_index'}) {
        my $_base_variable = "{" . "rowIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'row_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('RowResponse', $response);
    return $_response_object;
}

#
# cells_put_insert_worksheet_rows
#
# Insert several new worksheet rows.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $startrow The begin row index to be operated. (required)
# @param int $total_rows Number of rows to be operated. (optional, default to 1)
# @param boolean $update_reference Indicates if update references in other worksheets. (optional, default to true)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'startrow' => {
        data_type => 'int',
        description => 'The begin row index to be operated.',
        required => '1',
    },
    'total_rows' => {
        data_type => 'int',
        description => 'Number of rows to be operated.',
        required => '0',
    },
    'update_reference' => {
        data_type => 'boolean',
        description => 'Indicates if update references in other worksheets.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_put_insert_worksheet_rows' } = { 
    	summary => 'Insert several new worksheet rows.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_put_insert_worksheet_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_put_insert_worksheet_rows");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_put_insert_worksheet_rows");
    }

    # verify the required parameter 'startrow' is set
    unless (exists $args{'startrow'}) {
      croak("Missing the required parameter 'startrow' when calling cells_put_insert_worksheet_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'startrow'}) {
        $query_params->{'startrow'} = $self->{api_client}->to_query_value($args{'startrow'});
    }

    # query params
    if ( exists $args{'total_rows'}) {
        $query_params->{'totalRows'} = $self->{api_client}->to_query_value($args{'total_rows'});
    }

    # query params
    if ( exists $args{'update_reference'}) {
        $query_params->{'updateReference'} = $self->{api_client}->to_query_value($args{'update_reference'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

1;
