use Map::Metro::Standard::Moops;
use strict;
use warnings;

our $VERSION = '0.2300'; # VERSION
# ABSTRACT: IncompleteParse
# PODNAME: Map::Metro::Exception::IncompleteParse

class Map::Metro::Exception::IncompleteParse with Map::Metro::Exception {

    use Map::Metro::Exception -all;

    has info => (
        is => 'ro',
        isa => Str,
        lazy => 1,
        default => q{Missing either stations, lines or segments. Check the file for errors.},
    );

}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Map::Metro::Exception::IncompleteParse - IncompleteParse

=head1 VERSION

Version 0.2300, released 2016-01-14.

=head1 SOURCE

L<https://github.com/Csson/p5-Map-Metro>

=head1 HOMEPAGE

L<https://metacpan.org/release/Map-Metro>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Erik Carlsson.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
