# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.37
#
# Don't modify this file, modify the SWIG interface instead.

package Math::GSL::Permutation;
use base qw(Exporter);
use base qw(DynaLoader);
package Math::GSL::Permutationc;
bootstrap Math::GSL::Permutation;
package Math::GSL::Permutation;
@EXPORT = qw();

# ---------- BASE METHODS -------------

package Math::GSL::Permutation;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package Math::GSL::Permutation;

*gsl_permute = *Math::GSL::Permutationc::gsl_permute;
*gsl_permute_inverse = *Math::GSL::Permutationc::gsl_permute_inverse;
*gsl_permute_int = *Math::GSL::Permutationc::gsl_permute_int;
*gsl_permute_int_inverse = *Math::GSL::Permutationc::gsl_permute_int_inverse;
*gsl_permute_vector = *Math::GSL::Permutationc::gsl_permute_vector;
*gsl_permute_vector_inverse = *Math::GSL::Permutationc::gsl_permute_vector_inverse;
*gsl_permute_vector_int = *Math::GSL::Permutationc::gsl_permute_vector_int;
*gsl_permute_vector_int_inverse = *Math::GSL::Permutationc::gsl_permute_vector_int_inverse;
*gsl_permutation_alloc = *Math::GSL::Permutationc::gsl_permutation_alloc;
*gsl_permutation_calloc = *Math::GSL::Permutationc::gsl_permutation_calloc;
*gsl_permutation_init = *Math::GSL::Permutationc::gsl_permutation_init;
*gsl_permutation_free = *Math::GSL::Permutationc::gsl_permutation_free;
*gsl_permutation_memcpy = *Math::GSL::Permutationc::gsl_permutation_memcpy;
*gsl_permutation_fread = *Math::GSL::Permutationc::gsl_permutation_fread;
*gsl_permutation_fwrite = *Math::GSL::Permutationc::gsl_permutation_fwrite;
*gsl_permutation_fscanf = *Math::GSL::Permutationc::gsl_permutation_fscanf;
*gsl_permutation_fprintf = *Math::GSL::Permutationc::gsl_permutation_fprintf;
*gsl_permutation_size = *Math::GSL::Permutationc::gsl_permutation_size;
*gsl_permutation_data = *Math::GSL::Permutationc::gsl_permutation_data;
*gsl_permutation_get = *Math::GSL::Permutationc::gsl_permutation_get;
*gsl_permutation_swap = *Math::GSL::Permutationc::gsl_permutation_swap;
*gsl_permutation_valid = *Math::GSL::Permutationc::gsl_permutation_valid;
*gsl_permutation_reverse = *Math::GSL::Permutationc::gsl_permutation_reverse;
*gsl_permutation_inverse = *Math::GSL::Permutationc::gsl_permutation_inverse;
*gsl_permutation_next = *Math::GSL::Permutationc::gsl_permutation_next;
*gsl_permutation_prev = *Math::GSL::Permutationc::gsl_permutation_prev;
*gsl_permutation_mul = *Math::GSL::Permutationc::gsl_permutation_mul;
*gsl_permutation_linear_to_canonical = *Math::GSL::Permutationc::gsl_permutation_linear_to_canonical;
*gsl_permutation_canonical_to_linear = *Math::GSL::Permutationc::gsl_permutation_canonical_to_linear;
*gsl_permutation_inversions = *Math::GSL::Permutationc::gsl_permutation_inversions;
*gsl_permutation_linear_cycles = *Math::GSL::Permutationc::gsl_permutation_linear_cycles;
*gsl_permutation_canonical_cycles = *Math::GSL::Permutationc::gsl_permutation_canonical_cycles;

############# Class : Math::GSL::Permutation::gsl_permutation_struct ##############

package Math::GSL::Permutation::gsl_permutation_struct;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( Math::GSL::Permutation );
%OWNER = ();
%ITERATORS = ();
*swig_size_get = *Math::GSL::Permutationc::gsl_permutation_struct_size_get;
*swig_size_set = *Math::GSL::Permutationc::gsl_permutation_struct_size_set;
*swig_data_get = *Math::GSL::Permutationc::gsl_permutation_struct_data_get;
*swig_data_set = *Math::GSL::Permutationc::gsl_permutation_struct_data_set;
sub new {
    my $pkg = shift;
    my $self = Math::GSL::Permutationc::new_gsl_permutation_struct(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        Math::GSL::Permutationc::delete_gsl_permutation_struct($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


# ------- VARIABLE STUBS --------

package Math::GSL::Permutation;

 
@EXPORT_OK = qw/
                gsl_permutation_alloc 
                gsl_permutation_calloc 
                gsl_permutation_init 
                gsl_permutation_free 
                gsl_permutation_memcpy 
                gsl_permutation_fread 
                gsl_permutation_fwrite 
                gsl_permutation_fscanf 
                gsl_permutation_fprintf 
                gsl_permutation_size 
                gsl_permutation_data 
                gsl_permutation_get 
                gsl_permutation_swap 
                gsl_permutation_valid 
                gsl_permutation_reverse 
                gsl_permutation_inverse 
                gsl_permutation_next 
                gsl_permutation_prev 
                gsl_permutation_mul 
                gsl_permutation_linear_to_canonical 
                gsl_permutation_canonical_to_linear 
                gsl_permutation_inversions 
                gsl_permutation_linear_cycles 
                gsl_permutation_canonical_cycles
                gsl_permute
                gsl_permute_inverse
                gsl_permute_int 
                gsl_permute_int_inverse
                gsl_permute_vector
                gsl_permute_vector_inverse 
                gsl_permute_vector_int
                gsl_permute_vector_int_inverse 
            /;
%EXPORT_TAGS = ( all => [ @EXPORT_OK ] );

### wrapper interface ###
sub new {
    my ($class, $value) = @_;
    my $this = {};
    $this->{_length} = $value;
    $this->{_permutation} = gsl_permutation_calloc($value);
    bless $this, $class;
}

sub as_list {
    my $self=shift;
    $self->get( [ 0 .. $self->length - 1  ] );
}

sub get {
    my ($self, $indices) = @_;
    return  map {  gsl_permutation_get($self->{_permutation}, $_ ) } @$indices ;
}

sub raw { (shift)->{_permutation} }
sub length { (shift)->{_length} }




__END__

=head1 NAME

Math::GSL::Permutation - functions for creating and manipulating permutations

=head1 SYNOPSIS

 use Math::GSL::Permutation qw/:all/;
 my $permutation = Math::GSL::Permutation->new(30); # allocate and initialize a permutation of size 30
 my $lenght = $permutation->lenght; # returns the lenght of the permutation object, here it is 30
 gsl_permutation_swap($permutation->raw, 2,7); 
 # the raw method is made to use the underlying permutation structure of the permutation object
 my $value = $permutation->get(2); # returns the third value (starting from 0) of the permutation
 my @values = $permutation->as_list; # returns all the values of the permutation
 my @set = $permutation->get([0,1,2,3]); # returns the four first values of the permutation

=head1 DESCRIPTION

Here is a list of all the functions included in this module :

=over

=item gsl_permutation_alloc($n) - return a newly allocated permutation of size $n

=item gsl_permutation_calloc($n) - return a newly allocated permutation of size $n which is initialized to the identity

=item gsl_permutation_init($p) - initialize the permutation $p to the identity i.e. (0,1,2, ..., n-1) 

=item gsl_permutation_free($p) - free all the memory use by the permutaion $p 

=item gsl_permutation_memcpy($dest, $src) - copy the permutation $src into the permutation $dest, the two permutations must have the same lenght and return 0 if the operation suceeded, 1 otherwise 

=item gsl_permutation_fread($stream, $p) -  This function reads into the permutation $p from the open stream $stream (opened with the gsl_fopen function from the Math::GSL module) in binary format. The permutation $p must be preallocated with the correct length since the function uses the size of $p to determine how many bytes to read. The function returns 1 if there was a problem reading from the file. The data is assumed to have been written in the native binary format on the same architecture.

=item gsl_permutation_fwrite($stream, $p) - This function writes the elements of the permutation $p to the stream $stream (opened with the gsl_fopen function from the Math::GSL module) in binary format. The function returns 1 if there was a problem writing to the file. Since the data is written in the native binary format it may not be portable between different architectures.

=item gsl_permutation_fscanf($stream, $p) - This function reads formatted data from the stream $stream (opened with the gsl_fopen function from the Math::GSL module) into the permutation $p. The permutation $p must be preallocated with the correct length since the function uses the size of $p to determine how many numbers to read. The function returns 1 if there was a problem reading from the file.

=item gsl_permutation_fprintf($stream, $p, $format) - This function writes the elements of the permutation $p line-by-line to the stream $stream (opened with the gsl_fopen function from the Math::GSL module) using the format specifier $format, which should be suitable. "%zu\n" is a suitable format. The function returns 1 if there was a problem writing to the file. 

=item gsl_permutation_size($p) - return the size of the permutation $p 

=item gsl_permutation_data 

=item gsl_permutation_get($p, $i) - return the $i-th element of the permutation $p, return 0 if $i is outside the range of 0 to n-1 

=item gsl_permutation_swap($p, $i, $j) - exchange the $i-th position and the $j-th position of the permutation $p and return 0 if the operation suceeded, 1 otherwise

=item gsl_permutation_valid($p) - return 0 if the permutation $p is valid (if the n elements contain each of the numbers 0 to n-1 once and only once), 1 otherwise 

=item gsl_permutation_reverse($p) - reverse the elements of the permutation $p 

=item gsl_permutation_inverse($inv, $p) - compute the inverse of the permutation $p, storing it in $inv and return 0 if the operation succeeded, 1 otherwise 

=item gsl_permutation_next($p) - advance the permutation $p to the next permutation in lexicographic order and return 0 if the operation succeeded, 1 otherwise 

=item gsl_permutation_prev($p) - step backward from the permutation $p to the previous permutation in lexicographic order and return 0 if the operation suceeded, 1 otherwise 

=item gsl_permutation_mul($p, $pa, $pb) - combine the two permutation $pa and $pb into a single permutation $p and return 0 if the operation suceeded, 1 otherwise

=item gsl_permutation_linear_to_canonical($q, $p) - compute the canonical form the permutation $p and store it in $q and return 0 if the operation suceeded, 1 otherwise 

=item gsl_permutation_canonical_to_linear($p, $q) - convert a canonical permutation $q back into linear form and store it in $p and return 0 if the operation suceeded, 1 otherwise 

=item gsl_permutation_inversions($p) - return the number of inversions in the permutation $p 

=item gsl_permutation_linear_cycles($p) - return the number of cycles in the permutation $p, given a linear form 

=item gsl_permute_vector_int_inversegsl_permutation_canonical_cycles($p) - return the number of cycles in the permutation $p, given a canonical form

=item gsl_permute

=item gsl_permute_inverse

=item gsl_permute_int 

=item gsl_permute_int_inverse

=item gsl_permute_vector

=item gsl_permute_vector_inverse 

=item gsl_permute_vector_int

=back
 
 You have to add the functions you want to use inside the qw/put_funtion_here/ with spaces between each function. 
 You can also write use Math::GSL::CDF qw/:all/ to use all avaible functions of the module. 
 Other tags are also avaible, here is a complete list of all tags for this module.
For more informations on the functions, we refer you to the GSL offcial documentation: 
L<http://www.gnu.org/software/gsl/manual/html_node/>

 Tip : search on google: site:http://www.gnu.org/software/gsl/manual/html_node/ name_of_the_function_you_want

=head1 EXAMPLES

 use Math::GSL::Permutation qw/:all/;
 $p->{permutation} = gsl_permutation_calloc(5);
 print "The permutation contains [";
 map { print gsl_permutation_get($p->{permutation}, $_) . ", " } (0..3);
 print gsl_permutation_get($p->{permutation}, 4);
 print "] \n";
 print "We'll then swap the first and last elements of the permutation...\n";
 gsl_permutation_swap($p->{permutation}, 0, 4);
 print "The permutation now contains [";
 map { print gsl_permutation_get($p->{permutation},$_) . ", " } (0..3);
 print gsl_permutation_get($p->{permutation}, 4);
 print "] \n";


 use Math::GSL::Permutation qw/:all/;
 use Math::GSL::Vector qw/:all/;
 my $p->{permutation} = gsl_permutation_calloc(6); 
 gsl_permutation_init($p->{permutation});
 gsl_permutation_swap($p->{permutation}, 0, 1);
 print "The permutation has his first and second elements swapped : [";
 map { print gsl_permutation_get($p->{permutation}, $_) . "," } (0..4);
 print gsl_permutation_get($p->{permutation}, 5) . "] \n";    
 my $vec->{vector} = gsl_vector_alloc(6);
 map { gsl_vector_set($vec->{vector}, $_, $_) } (0..5);
 
 print "We will now apply the permutation to this vector : [";
 map { print gsl_vector_get($vec->{vector}, $_) . "," } (0..4);
 print gsl_vector_get($vec->{vector}, 5) . "] \n";     
 gsl_permute_vector($p->{permutation}, $vec->{vector});
 print "The vector is now : [";
 map { print gsl_vector_get($vec->{vector}, $_) . "," } (0..4);
 print gsl_vector_get($vec->{vector}, 5) . "] \n";     


=head1 AUTHORS

Jonathan Leto <jonathan@leto.net> and Thierry Moisan <thierry.moisan@gmail.com>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 Jonathan Leto and Thierry Moisan

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut
1;
