#!/usr/bin/perl -w

use 5.008001;

use Module::Build;

my $build = Module::Build->new(
    module_name     => 'Method::Signatures',
    license         => 'perl',

    configure_requires => {
        'Module::Build'     => '0.26',
    },

    build_requires      => {
        'Module::Build'     => '0.26',
        'Test::More'        => '0.62',
    },

    requires        => {
        'perl'              => '5.8.1',

        'Devel::Declare'    => '0.002000',
        'Data::Alias'       => '1.07',
        'Sub::Name'         => '0.04',
        'Readonly'          => '1.03',
    },

    recommends          => {
        # Makes "is ro" faster.
        'Readonly::XS'      => '1.02',
    },

    auto_features       => {
        "fast 'is ro' (needs Readonly::XS)" => {
            description             => 'faster "is ro" type',
            requires                => { 'Readonly::XS' => '1.02' }
        }
    },
    
    dist_author     => 'Michael G Schwern <schwern@pobox.com>',
    
    meta_merge      => {
        resources => {
            license     => 'http://dev.perl.org/licenses/',
            bugtracker  =>
                'http://rt.cpan.org/NoAuth/Bugs.html?Dist=Method-Signatures',
            repository  => 'https://github.com/schwern/method-signatures/tree',
        },
    },
);
$build->create_build_script;
