#!/usr/bin/perl -w
use strict;
use warnings;
use Test;

BEGIN {
    chdir 't' if -d 't';
    unshift @INC, '../blib/lib';
    plan tests => 19;
}

use HTML::TokeParser::Simple;

my $p = HTML::TokeParser::Simple->new(\*DATA);
ok( ref $p, 'HTML::TokeParser::Simple' );

my $token = $p->get_token;
ok( ref $token, 'HTML::TokeParser::Simple' );
ok( $token->is_declaration, 1 );

$token = $p->get_token for ( 1..2 );
ok( $token->is_start_tag( 'html' ), 1 );
ok( $token->return_tag, 'html' );
ok( $token->is_start_tag( 'fake tag' ), '' );

# important to remember that whitespace counts as a token.
$token = $p->get_token for ( 1..4 ); 
ok( $token->is_comment, 1 );
ok( $token->return_text, '<!-- This is a comment -->' );

$token = $p->get_token for ( 1..3 ); 
ok( $token->is_text, 1 );

$token = $p->get_token;
ok( $token->is_end_tag( 'title' ) );

$token = $p->get_token for ( 1..2 );
ok( $token->is_process_instruction, 1 );
ok( substr( $token->return_token0, 0, 3) , 'php' );

do { $token = $p->get_token } until $token->is_start_tag( 'body' );
ok( ref $token->return_attr, 'HASH' );
ok( $token->return_attr()->{'bgcolor'}, '#ffffff' );
ok( $token->return_attr()->{'alink'}, '#0000ff' );

my $arrayref = $token->return_attrseq;
ok( ref $arrayref, 'ARRAY' );
ok( scalar @{$arrayref}, 2 );
ok( $arrayref->[0], 'alink' );
ok( $arrayref->[1], 'bgcolor' );

sub copy_array {
	# use this to copy array without copying the reference
	my $aref = shift;
	my @new_array;
	push @new_array, $_ foreach @$aref;
	return \@new_array;
}

sub arrays_equal {
	my ( $aref1, $aref2 ) = @_;
	return 0 if @$aref1 != @$aref2; 
	foreach ( 0 .. $#$aref1 ) {
		return 0 if $aref1->[$_] ne $aref2->[$_];
	}
	return 1;
}
__DATA__
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML//EN">
<html>
	<head>
		<!-- This is a comment -->
		<title>This is a title</title>
		<?php 
			print "<!-- this is generated by php -->";
		?>
	</head>
	<body alink="#0000ff" bgcolor="#ffffff">
		<h1>Do not edit this HTML lest the tests fail!!!</h1>
	</body>
</html>
